/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "playerfactory.h"
#include "computerplayer.h"
#include "aibase.h"
// Players we know
#include "players/abigail/abigail.h"
#include "players/jack/jack.h"
#include "players/norman/norman.h"
#include "players/sally/sally.h"
#include "players/wally/wally.h"
// Game players we know
#include "cribbageplayer.h"
#include "heartsplayer.h"
#include "warplayer.h"
#include "spadesplayer.h"

#include <qstring.h>

PlayerFactory::PlayerFactory()
{}

PlayerFactory::~PlayerFactory()
{
    int size=m_players.size();

    for (int i=0; i < size; ++i)
        delete m_players[i];
}

const vector<ComputerPlayer *>& PlayerFactory::players() const
{
    return m_players;
}

vector<ComputerPlayer *>& PlayerFactory::players()
{
    return m_players;
}

bool PlayerFactory::createPlayer(const QString &playersName, const QString &game)
{
    if (setupAIBase(playersName))
        if (setupGamePlayer(game))
            return true;
    return false;
}

void PlayerFactory::clear()
{
    int size=m_players.size();

    for (int i=0; i < size; ++i)
        delete m_players[i];
    m_players.clear();
    m_ais.clear();
}

vector<QString> PlayerFactory::playerNames() const
{
    vector<QString> players;

    // This is the only location where the names of the players are capitalised.
    players.push_back("Abigail");
    players.push_back("Jack");
    players.push_back("Norman");
    players.push_back("Sally");
    players.push_back("Wally");
    return players;
}

bool PlayerFactory::setupAIBase(const QString &playersName)
{
    if (playersName == "abigail")
        m_ais.push_back(new Abigail());
    else if (playersName == "jack")
        m_ais.push_back(new Jack());
    else if (playersName == "norman")
        m_ais.push_back(new Norman());
    else if (playersName == "sally")
        m_ais.push_back(new Sally());
    else if (playersName == "wally")
        m_ais.push_back(new Wally());
    else
        return false;
    return true;
}

bool PlayerFactory::setupGamePlayer(const QString &game)
{
    if (game == "cribbage")
    {
        m_players.push_back(new CribbagePlayer(*m_ais.back()));
        m_players.back()->setName(m_ais.back()->name());
        m_players.back()->setLevel(m_ais.back()->skillLevel("cribbage"));
    }
    else if (game == "hearts")
    {
        m_players.push_back(new HeartsPlayer(*m_ais.back()));
        m_players.back()->setName(m_ais.back()->name());
        m_players.back()->setLevel(m_ais.back()->skillLevel("hearts"));
    }
    else if (game == "spades")
    {
        m_players.push_back(new SpadesPlayer(*m_ais.back()));
        m_players.back()->setName(m_ais.back()->name());
        m_players.back()->setLevel(m_ais.back()->skillLevel("spades"));
    }
    else if (game == "war")
    {
        m_players.push_back(new WarPlayer(*m_ais.back()));
        m_players.back()->setName(m_ais.back()->name());
        m_players.back()->setLevel(m_ais.back()->skillLevel("war"));
    }
    else
        return false;
    return true;
}
