/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#include "bitmanipulator.h"

#include <cmath>
#include <iostream>
using std::cout;
using std::endl;

unsigned BitManipulator::mask(int maskLength, short maskStart)
{
    unsigned mask=0x0;

    // Create the mask of appropriate length
    for (int bitPos=0; bitPos < maskLength; bitPos++)
        mask+=static_cast<unsigned>(pow(2.0, bitPos));
    // Shift the mask over to the right location.
    mask=mask << maskStart;
    return mask;
}

string BitManipulator::base10ToBase2(long number)
{
    string binNumber="";

    while (number != 0)
    {
        ((number % 2) == 1 ? binNumber.insert(0, "1") : binNumber.insert(0, "0"));
        number = static_cast<int>(floor(number / 2));
    }
    return binNumber;
}

void BitManipulator::printBits(unsigned variable, int numberBits, int breakUp)
{
    for (int bitPos=numberBits-1; bitPos > -1; bitPos--)
    {
        // If the bit is a 1 print a 1, else print a 0
        ((mask(1, bitPos) & variable) >> bitPos) == 0x1 ? cout << "1": cout << "0";
        // Group the bits for nice printing.
        if ((bitPos % breakUp) == 0)
            cout << " ";
    }
    cout << endl;
}

vector<string> BitManipulator::binarySequence(int length)
{
    vector<string> base2Sequence;
    int lengthDifference, number=1;

    while (true)
    {
        // Create the sequence.
        base2Sequence.push_back(base10ToBase2(number));
        //Make sure all of our numbers have the same length
        lengthDifference = length -  base2Sequence[number - 1].length();
        if (lengthDifference < length)
            for (int i=0; i < lengthDifference; i++)
                base2Sequence[number - 1].insert(0, "0");
        // We know we're done when we reach a string of all 1's.
        if (base2Sequence[number - 1].find("0") == string::npos)
            break;
        // If we were given a 0 we're done.
        else if (length == 0)
            break;
        else
            number++;
    }
    return base2Sequence;
}
