/***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SALLYSPADESAI_H
#define SALLYSPADESAI_H

#include "cardsequence.h"
#include "card.h"
#include "basicgamestrategies.h"

class RuleBase;

/**
 * This is the strategy used by Sally to play Spades.
 *
 * @author John Schneiderman
 */
class SallySpadesAI
{
public:
    /**
     * Constructor
     * @param playSequence is the current play sequence.
     * @param rules is the current rules.
     * @param hand is the current hand.
     */
    SallySpadesAI(const CardSequence &playSequence, const RuleBase &rules, const CardSequence &hand);
    /**
     * Destructor
     */
    ~SallySpadesAI();
    /**
     * Selects a card to play for normal play.
     * @return the card selected.
     */
    CardSequence selectCards() const;
    /**
     * Determines if we want to bid nil or the number of tricks for our contract.
     * @param partnersBid is our partners bid.
     * @return the number of tricks for our contract, NIL, or DOUBLE_NIL.
     */
    int bidNil(int partnersBid) const;
    /**
     * Determines if we want to bid double nil.
     * @param score is our current score.
     * @param opponetScore is our opponents score.
     * @return DOUBLE_NIL if we want to bid double nil, NON_BID if we don't.
     */
    int bidDoubleNil(int score, int opponetScore) const;
    /**
     * Selects the cards to exchange with our partner because of a nil or double nil bid.
     * @return the cards selected to exchange.
     */
    CardSequence exchangeCards() const;
    /**
     * Selects a card to play for when we bid nil or double nil.
     * @return the card selected.
     */
    CardSequence selectCardsForNilBid() const;

private:
    /// @param m_playSequence is the play sequence we're working with.
    CardSequence m_playSequence;
    /// @param m_hand is the hand of cards we're working with.
    CardSequence m_hand;
    /// @param m_pRules are the rules for the game.
    const RuleBase *m_pRules;
    /// @param basicStrategies is the general basic strategies.
    BasicGameStrategies basicStrategies;
};
#endif
