/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/

/**
 * Constructor call.
 */
void UserLogin::init()
{
    //Set logo and icon
    logo->setPixmap(QImage::fromMimeSource("kardsgt.png"));
    setIcon(QPixmap::fromMimeSource("kardsgticon.png"));
    userProfileDB = 0;
}

/**
 * Destructor call.
 */
void UserLogin::destroy()
{
    if (userProfileDB != 0)
        delete userProfileDB;
}

/**
 * This validates that the current text meets the qualifications to be able to start the game.
 */
void UserLogin::validatecurrentText()
{
    if ((userName->currentText().length() >= UserLogin::USER_NAME_MIN) && (userName->currentText().contains(" ") == 0) && (password->text().length() >= UserLogin::PASSWORD_MIN))
        bttnLogin->setEnabled(true);
    else if (userName->currentText().length() >= UserLogin::USER_NAME_MIN && (userName->currentText().contains(" ") == 0))
    {
        bttnLocal->setEnabled(true);
        removeUser->setEnabled(true);
    }
    else
    {
        bttnLogin->setEnabled(false);
        bttnLocal->setEnabled(false);
        removeUser->setEnabled(false);
    }
}

/**
 * An accessor to the user's name.
 * @return the users name.
 */
QString UserLogin::getUserName()
{
    return userName->currentText();
}

/**
 * An accessor to the user's password.
 * @return the user's password.
 */
QString UserLogin::getPassword()
{
    return password->text();
}

/**
 * Information on how to use the log-in screen.
 */
void UserLogin::helpLogin()
{
    QMessageBox::information(this, tr("Login Help"), tr("The user name box is where you can enter your user name. \n The user name must be between 2 and 10 characters inclusive. \n They can be any combination of letters and numbers. \n Once you have entered a name and pressed the enter key, you can click on Local Game to start.\n No password is needed as the networking code has not be created.\n The remove button is used to remove a user profile that is no longer needed."));
}

/**
 * Saves the user profile database.
 */
void UserLogin::saveProfile()
{
    std::vector<QString> users;

    if (userName->listBox()->count() == 0)
        userName->insertItem(userName->currentText());
    userName->listBox()->sort();
    for (int i=0, size=userName->listBox()->count(); i < size; ++i)
        users.push_back(userName->listBox()->text(i));
    userProfileDB->setUsers(users);
    userProfileDB->saveUserProfileDatabase();
}

/**
 * Loads the user profile database.
 * @param path is the path to the directory that has the user profile database.
 */
void UserLogin::loadUserProfiles(QString path)
{
    userProfileDB = new UserProfileDatabase(path);
    userProfileDB->loadUserProfileDatabase();
    std::vector<QString> users=userProfileDB->users();

    for (int i=0, size=users.size(); i < size; ++i)
        userName->insertItem(users[i]);
}

/**
 * Removes the current profile name shown from our user profile database.
 */
void UserLogin::removeProfile()
{
    if (QMessageBox::question(this, "Remove profile", QString("Do you really want to remove the profile: %1?").arg(userName->currentText()), QMessageBox::Yes, QMessageBox::No) == QMessageBox::Yes)
    {
        std::vector<QString> users;

        userName->removeItem(userName->currentItem());
        userName->listBox()->sort();
        for (int i=0, size=userName->listBox()->count(); i < size; ++i)
            users.push_back(userName->listBox()->text(i));
        userProfileDB->setUsers(users);
    }
}
