/***************************************************************************
 *   Copyright (C) 2005 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef _KARD_DRAG_H_
#define _KARD_DRAG_H_

#include <qdragobject.h>

class Kard;

/**
 * This is the drag object to move Kards around KardSelections and KardPiles.
 *
 * @author John Schneiderman
 */
class KardDrag: public QDragObject
{
    Q_OBJECT

public:
    /**
     * This creates the kard object to drag.
     * @param kard is the kard we want to drag.
     * @param parent is the parent widget.
     * @param name is the name of the current drag.
     */
    KardDrag(Kard &kard, QWidget *parent=0, const char *name=0);
    /**
     * Destructor.
     */
    ~KardDrag();
    /**
     * This gives the type conversion for our drag.
     * @param index is the type of conversion to use.
     * @note formats available are: \n
     * 0: application/x-kard
     * @return the type of conversion.
     */
    const char * format(int index) const;
    /**
     * This will encode our Kard for dragging.
     * @param format is the type of conversion for our Kard.
     * @return the converted kard.
     */
    QByteArray encodedData(const char *format) const;
    /**
     * This determines if we can decode a dragged object.
     * @param source is where the dragged object is coming from.
     * @return true if we can decode it, false elsewise.
     */
    static bool canDecode(const QMimeSource *source);
    /**
     * This will decode a dragged object.
     * @param source is where the dragged kard information is stored.
     * @param kard is where the converted information is placed.
     * @return true if we were successful in converting the source into a kard.
     */
    static bool decode(const QMimeSource *source, Kard &kard);

private:
    /// @param m_pKard is the kard we're dragging.
    Kard *m_pKard;
};
#endif
