 /***************************************************************************
 *   Copyright (C) 2006 by John Schneiderman                               *
 *   JohnMS@member.fsf.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.             *
 ***************************************************************************/
#ifndef SALLYCRIBBAGEAI_H
#define SALLYCRIBBAGEAI_H

#include "cardsequence.h"
#include "card.h"
#include "basicgamestrategies.h"

class RuleBase;

/**
 * This is the strategy for Cribbage for Sally.
 *
 * @author John Schneiderman
 */
class SallyCribbageAI
{
public:
    /**
     * Constructor.
     * @param playSequence is the current play sequence.
     * @param rules is the rules for Cribbage.
     * @param hand is the current hand.
     */
    SallyCribbageAI(const CardSequence &playSequence, const RuleBase &rules, const CardSequence &hand);
    /**
     * Destructor.
     */
    ~SallyCribbageAI();
    /**
     * Selects a card to play.
     * @return the card selected.
     */
    Card selectCard() const;
    /**
     * Selects two cards for her crib.
     * @return the cards selected.
     */
    CardSequence myCrib() const;
    /**
     * Selects two cards for her crib.
     * @return the cards selected.
     */
    CardSequence opponentsCrib() const;

private:
    /// @param m_playSequence is the play sequence we're working with.
    CardSequence m_playSequence;
    /// @param m_hand is the hand of cards we're working with.
    CardSequence m_hand;
    /// @param m_pRules are the rules for the game.
    const RuleBase *m_pRules;
    /// @param basicStrategies is the general basic strategies.
    BasicGameStrategies basicStrategies;

    /**
     * Calculates the score of the hand using just the runs and pairs.
     * @param hand is the sequence of cards to perform the calculations on.
     * @return is the calculated score.
     */
    int calculateScore(const CardSequence &hand) const;
};
#endif
