/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2005-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "kardselection.h"
#include "cardsequence.h"
#include "kard.h"
#include "kardsgterror.h"

#include <QString>
#include <QLayout>
#include <QPushButton>
#include <QHBoxLayout>
#include <QVBoxLayout>

KardSelection::KardSelection(const QString &caption, int number, const CardSequence &choices, const QString &cardImagePath, const QString &cardBackImage, QWidget *parent, bool modal): QDialog(parent)
{
    QVBoxLayout *mainLayout=new QVBoxLayout(this);
    QHBoxLayout *selectedLayout=new QHBoxLayout(); // A widget can only use one layout at a time.

    m_numberToChoose=number;
    setWindowTitle(caption);
    setModal(modal);

    // Set up the selected sequences
    m_pKardsSelected = new KardSequence(this);
    m_pKardsSelected->setCardBackImage(cardBackImage);
    m_pKardsSelected->setCardFrontImagePath(cardImagePath);
    m_pKardsSelected->setFaceUp(true);

    // Setup the selection sequences
    m_pKardsSelection = new KardSequence(this);
    m_pKardsSelection->setCardBackImage(cardBackImage);
    m_pKardsSelection->setCardFrontImagePath(cardImagePath);
    m_pKardsSelection->setFaceUp(true);
    m_pKardsSelection->setCardSequence(choices);

    // Setup the OK button
    m_pSelectButton = new QPushButton(this);
    m_pSelectButton->setText("Okay");
    m_pSelectButton->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
    m_pSelectButton->setEnabled(false);

    // Setup widget sizes
    if (parent)
    {
        setMinimumSize(Kard::PREFERRED_WIDTH * 2, Kard::PREFERRED_HEIGHT * 3);
        setMaximumSize(parent->width(), parent->height());
        m_pKardsSelection->setMaximumSize(parent->width(), Kard::PREFERRED_HEIGHT);
        m_pKardsSelected->setMaximumSize(parent->width(), Kard::PREFERRED_HEIGHT);
    }

    // Setup widgets
    connect(m_pKardsSelection, SIGNAL(kardSelected(Kard &)), m_pKardsSelected, SLOT(addKard(Kard &)));
    connect(m_pKardsSelection, SIGNAL(kardSelected(Kard &)), m_pKardsSelection, SLOT(removeKard(Kard &)));
    connect(m_pKardsSelection, SIGNAL(kardSelected(Kard &)), this, SLOT(enableButton()));
    connect(m_pKardsSelected, SIGNAL(kardSelected(Kard &)), m_pKardsSelection, SLOT(addKard(Kard &)));
    connect(m_pKardsSelected, SIGNAL(kardSelected(Kard &)), m_pKardsSelected, SLOT(removeKard(Kard &)));
    connect(m_pKardsSelected, SIGNAL(kardSelected(Kard &)), this, SLOT(enableButton()));
    connect(m_pSelectButton, SIGNAL(clicked()), this, SLOT(accept()));
    selectedLayout->addWidget(m_pKardsSelected);
    selectedLayout->addWidget(m_pSelectButton);
    mainLayout->addWidget(m_pKardsSelection);
    mainLayout->addLayout(selectedLayout);
}

KardSelection::~KardSelection()
{
    delete m_pKardsSelection;
    delete m_pKardsSelected;
    delete m_pSelectButton;
}

const CardSequence& KardSelection::selection() const
{
    if (m_pKardsSelected != NULL)
        return m_pKardsSelected->cardSequence();
    else
        throw KardsGTError("KardSelection", "selection", "m_pKardsSelected is NULL!");
}

void KardSelection::enableButton()
{
    if (m_pKardsSelected->size() == m_numberToChoose)
        m_pSelectButton->setEnabled(true);
    else
        m_pSelectButton->setEnabled(false);
}
