/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2007-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef SUITREQUEST_H
#define SUITREQUEST_H

#include "card.h"

#include <QDialog>
#include <QLabel>
#include <QVBoxLayout>

class QPushButton;
class QLabel;
class QComboBox;

/**
 * This displays a dialogue that allows a player to select a suit from a standard US or UK pack.
 *
 * @author John Schneiderman
 */
class SuitRequest: public QDialog
{
    Q_OBJECT

public:
    /**
     * Constructor for a suit request widget dialogue.
     * @param caption is the caption for the dialogue.
     * @param canPass is true if the player can pass, false if he cannot.
     * @param canBidNoSuit is true if the player can select no suit, false if he cannot
     * @param parent is the parent of our dialogue.
     * @param modal is true if we want our dialogue to be modal, false elsewise.
     */
    SuitRequest(const QString &caption, bool canPass, bool canBidNoSuit, QWidget *parent=0, bool modal=true);
    /**
     * The destructor for our dialogue.
     */
    ~SuitRequest();
    /**
     * An accessor to the suit the player selected.
     * @return the suit the player selected.
     * @note If a player can pass and selects to pass, then SUIT_ERR is returned.
     * @throw KardsGTError if cannot determine suit selection.
     */
    Card::Suit suit() const;

private:
    /// @param m_pBttnSuit is the button to select our suit.
    QPushButton* m_pBttnSuit;
    /// @param m_pLblInstructions is the instructions for the user.
    QLabel* m_pLblInstructions;
    /// @param m_pCmbBxSuit is the suits the player selects from.
    QComboBox* m_pCmbBxSuit;
    /// @param m_pLayout is the layout to hold all of our widgets.
    QVBoxLayout *m_pLayout;
    /// @param m_canBidNoSuit determines if a player can select no suit as their suit.
    bool m_canBidNoSuit;
};
#endif
