/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2006-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "gamefactory.h"
#include "kardsgterror.h"
// Games we know how to launch
#include "cribbageinterface.h"
#include "warinterface.h"
#include "heartsinterface.h"
#include "oldmaidinterface.h"
#include "spadesinterface.h"
#include "euchreinterface.h"
#include "crazyeightsinterface.h"

#include <QString>
#include <QStackedWidget>

GameFactory::GameFactory()
{
    m_pGame=0;
}

GameFactory::~GameFactory()
{
    if (m_pGame != 0)
        delete m_pGame;
}

const GameBase& GameFactory::game() const
{
    if (m_pGame == 0)
        throw KardsGTError("GameFactory", "game const", "m_pGame has not be set!");
    else
        return *m_pGame;
}

GameBase& GameFactory::game()
{
    if (m_pGame == 0)
        throw KardsGTError("GameFactory", "game", "m_pGame has not be set!");
    else
        return *m_pGame;
}

bool GameFactory::createGame(UserProfileDatabase &profileDatabase, const QString &game, QStackedWidget &layout)
{
    if (m_pGame != 0) // Prevent more than one game from being created.
        return false;
    if (setupGame(profileDatabase, game, layout))
        return true;
    else
        return false;
}

void GameFactory::clear()
{
    if (m_pGame != 0)
    {
        delete m_pGame;
        m_pGame = 0;
    }
}

bool GameFactory::hasGame() const
{
    if (m_pGame != 0)
        return true;
    else
        return false;
}

bool GameFactory::setupGame(UserProfileDatabase &profileDatabase, const QString &game, QStackedWidget &layout)
{
    if (game == "crazy eights") 
        m_pGame = new CrazyEightsInterface(profileDatabase, &layout); 
    else if (game == "cribbage")
        m_pGame = new CribbageInterface(profileDatabase, &layout);
    else if (game == "war")
        m_pGame = new WarInterface(profileDatabase, &layout);
    else if (game == "hearts")
        m_pGame = new HeartsInterface(profileDatabase, &layout);
    else if (game == "old maid")
        m_pGame = new OldMaidInterface(profileDatabase, &layout);
    else if (game == "spades")
        m_pGame = new SpadesInterface(profileDatabase, &layout);
    else if (game == "euchre")
        m_pGame = new EuchreInterface(profileDatabase, &layout);
    else
        return false;
    layout.addWidget(dynamic_cast<QWidget *>(m_pGame));
    return true;
}
