/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2006-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "cribbageblock.h"

#include <QPoint>
#include <QPainter>

CribbageBlock::CribbageBlock(const QColor &colour, int numberOfPegs, int x, int y, int orientation, QWidget *parent): QWidget(parent)
{
    m_orientation=orientation;
    m_pegs=numberOfPegs;
    m_positionX=x;
    m_positionY=y;
    m_height=(m_pegs * 2) + 1; // Calculate how tall to make the block
    m_colour=colour;
}

QPoint CribbageBlock::position() const
{
    return QPoint(m_positionX, m_positionY);
}

void CribbageBlock::setPosition(int x, int y)
{
    m_positionX=x;
    m_positionY=y;
}

int CribbageBlock::height() const
{
    return m_height;
}

void CribbageBlock::setHeight(int h)
{
    m_height=h;
}

void CribbageBlock::draw(QPainter *painter)
{
    QBrush brush=painter->brush();

    painter->setBrush(m_colour);
    //Determine if we're going to be vertically or horizontally drawn
    if (m_orientation == VERTICAL)
    {
        painter->drawRect(m_positionX, m_positionY, BLOCK_WIDTH, m_height);
        painter->setBrush(QBrush(Qt::black));
        for (int i=0, offset=1; i < m_pegs; ++i, offset+=2)
            painter->drawEllipse(m_positionX + 1, m_positionY + offset, BLOCK_WIDTH / 2, BLOCK_HEIGHT / 2);
    }
    else if (m_orientation == HORIZONTAL)
    {
        painter->drawRect(m_positionX, m_positionY, m_height, BLOCK_WIDTH);
        painter->setBrush(QBrush(Qt::black));
        for (int i=0, offset=0; i < m_pegs; ++i, offset+=2)
            painter->drawEllipse(m_positionX + offset, m_positionY + 1, BLOCK_WIDTH / 2, BLOCK_HEIGHT / 2);
    }
    painter->setBrush(brush);
}
