/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2006-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef WARAI_H
#define WARAI_H

#include "cardsequence.h"

/**
 * This is the AI to play a game of war for Wally.
 *
 * @author John Schneiderman
 */
class WallyWarAI
{
public:
    /**
     * Constructor.
     * @param hand is the hand that Wally has to play.
     */
    WallyWarAI(const CardSequence &hand);
    /**
     * Destructor.
     */
    ~WallyWarAI();
    /**
     * Selects a card to play.
     * @return the card selected.
     */
    CardSequence selectCards() const;

private:
    /// @param m_hand is the hand of cards we're working with.
    CardSequence m_hand;
};
#endif
