TEMPLATE = app

INCLUDEPATH +=  players \
                games/war \
                games/spades \
                games/oldmaid \
                games/hearts \
                games/euchre \
                games/cribbage \
                games/crazyeights \
                gamebase \
                gamebase/widgets/

CONFIG(debug, debug|release) {
    TARGET = kardsgt-debug

    DESTDIR = ../debug

    TARGETDEPS +=   players/debug/libplayers-debug.a \
                    games/war/debug/libwar-debug.a \
                    games/spades/debug/libspades-debug.a \
                    games/oldmaid/debug/liboldmaid-debug.a \
                    games/hearts/debug/libhearts-debug.a \
                    games/euchre/debug/libeuchre-debug.a \
                    games/cribbage/debug/libcribbage-debug.a \
                    games/crazyeights/debug/libcrazyeights-debug.a \
                    gamebase/debug/libkardsgt-debug.a

    LIBS += players/debug/libplayers-debug.a \
            games/war/debug/libwar-debug.a \
            games/spades/debug/libspades-debug.a \
            games/oldmaid/debug/liboldmaid-debug.a \
            games/hearts/debug/libhearts-debug.a \
            games/euchre/debug/libeuchre-debug.a \
            games/cribbage/debug/libcribbage-debug.a \
            gamebase/debug/libkardsgt-debug.a \
            games/crazyeights/debug/libcrazyeights-debug.a
}

CONFIG(release, debug|release) {
    TARGET = kardsgt

    DESTDIR = ../release

    TARGETDEPS +=   players/release/libplayers.a \
                    games/war/release/libwar.a \
                    games/spades/release/libspades.a \
                    games/oldmaid/release/liboldmaid.a \
                    games/hearts/release/libhearts.a \
                    games/euchre/release/libeuchre.a \
                    games/cribbage/release/libcribbage.a \
                    games/crazyeights/release/libcrazyeights.a \
                    gamebase/release/libkardsgt.a

    LIBS += players/release/libplayers.a \
            games/war/release/libwar.a \
            games/spades/release/libspades.a \
            games/oldmaid/release/liboldmaid.a \
            games/hearts/release/libhearts.a \
            games/euchre/release/libeuchre.a \
            games/cribbage/release/libcribbage.a \
            gamebase/release/libkardsgt.a \
            games/crazyeights/release/libcrazyeights.a
}

FORMS += configurekardsgt.ui \
         kardsgtinterface.ui \
         playerselection.ui

HEADERS += gamefactory.h \
           kardsgtinterface.h \
           playerfactory.h \
           playerselection.h \
           configurekardsgt.h

SOURCES += gamefactory.cpp \
           kardsgtinterface.cpp \
           main.cpp \
           playerfactory.cpp \
           configurekardsgt.cpp \
           playerselection.cpp

QT +=  assistant

RESOURCES += images.qrc

CONFIG += assistant \
          warn_on \
          qt \
          thread \
          exceptions \
          stl \
          debug_and_release

debug {
    CONFIG -= release
    CONFIG += debug
}

release {
    QMAKE_CXXFLAGS_RELEASE += -fexceptions

    CONFIG -= debug
    CONFIG += release
}

target.path += /usr/bin/

man.path += /usr/share/man/man6
man.files += doc/kardsgt.6

docs.path += /usr/share/doc/kardsgt
docs.files +=   INSTALL \
                ChangeLog \
                COPYING \
                CREDITS

data.path += /usr/share/kardsgt/
data.files +=   doc/*.html \
                doc/kardsgt.dcf

helpImages.path += /usr/share/kardsgt/images
helpImages.files += doc/images/*.jpg \
                    doc/images/*.png

icons.path += /usr/share/icons
icons.files += images/kardsgticon.png

INSTALLS += target \
            man \
            docs \
            data \
            helpImages \
            icons
