/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2006-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "userprofiledatabase.h"

#include <QFile>
#include <QTextStream>
#include <QTextCodec>
#include <QString>

#include <vector>
using std::vector;
using std::pair;

UserProfileDatabase::UserProfileDatabase(): m_settings()
{}

UserProfileDatabase::~UserProfileDatabase()
{}

pair<int, int> UserProfileDatabase::gameStatistics(const QString &game) const
{
    pair<int, int> stat;

    stat.first = m_settings.value(game + "/GamesWon", 0).toInt();
    stat.second = m_settings.value(game + "/GamesPlayed", 0).toInt();
    return stat;
}

void UserProfileDatabase::setGameStatistics(const QString &game, bool won)
{
    pair<int, int> stat = gameStatistics(game);

    if (won)
        stat.first++;
    stat.second++;
    m_settings.setValue(game + "/GamesWon", stat.first);
    m_settings.setValue(game + "/GamesPlayed", stat.second);
}

QString UserProfileDatabase::userMoodImage(const QString &mood) const
{
    return m_settings.value("userMoodImage_" + mood, "player-male.png").toString();
}

QString UserProfileDatabase::pathToCardFrontImages() const
{
    return m_settings.value("cardFrontImagePath", "default").toString();
}

QString UserProfileDatabase::cardBackImageFilename() const
{
    return m_settings.value("cardBackImage", "back00.png").toString();
}

void UserProfileDatabase::setUserMoodImage(const QString &mood, const QString &filename)
{
    m_settings.setValue("userMoodImage_" + mood, filename);
}

void UserProfileDatabase::setPathToCardFrontImages(const QString &path)
{
    m_settings.setValue("cardFrontImagePath", path);
}

void UserProfileDatabase::setCardBackImageFilename(const QString &image)
{
    m_settings.setValue("cardBackImage", image);
}

QString UserProfileDatabase::userName() const
{
    return m_settings.value("userName", "UNKNOWN").toString();
}

void UserProfileDatabase::setUserName(const QString &userName)
{
    m_settings.setValue("userName", userName);
}

