/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2005-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "kardmessagedisplay.h"
#include "kard.h"
#include "kardsgterror.h"

#include <QLayout>
#include <QLabel>
#include <QPushButton>
#include <QHBoxLayout>
#include <QVBoxLayout>

KardMessageDisplay::KardMessageDisplay(const QString &caption, const CardSequence &hand, const QString &message, const QString &cardImagePath, const QString &cardBackImage, QWidget *parent, bool modal): QDialog(parent)
{
    setMaximumSize(parent->width(), parent->height());
    setWindowTitle(caption);
    setModal(modal);
    vector<CardSequence> hands;
    vector<QString> messages;

    hands.push_back(hand);
    messages.push_back(message);
    displayMessage(hands, messages, cardImagePath, cardBackImage);
}

KardMessageDisplay::KardMessageDisplay(const QString &caption, const vector<CardSequence> &hands, const vector<QString> &messages, const QString &cardImagePath, const QString &cardBackImage, QWidget *parent, bool modal): QDialog(parent)
{
    setMaximumSize(parent->width(), parent->height());
    setWindowTitle(caption);
    setModal(modal);

    displayMessage(hands, messages, cardImagePath, cardBackImage);
}

KardMessageDisplay::~KardMessageDisplay()
{
    if (m_pDisplay != NULL)
        delete m_pDisplay;
    if (m_pBttnOkay != NULL)
        delete m_pBttnOkay;
}

void KardMessageDisplay::displayMessage(const vector<CardSequence> &hands, const vector<QString> &messages, const QString &cardImagePath, const QString &cardBackImage)
{
    Kard *kard;

    if (hands.size() != messages.size())
        throw KardsGTError("KardMessageDisplay", "displayMessage", "hands is not the same size as messages!");
    m_hands=hands;
    m_messages=messages;
    for (int i=0, size=m_hands.size(); i < size; ++i)
    {
        m_messageLayouts.push_back(new QHBoxLayout());

        // Create a Kard from the sequence
        for (int j=0; j < m_hands[i].size(); ++j)
        {
            kard=new Kard();
            if (! cardBackImage.isEmpty())
                kard->setCardBack(cardBackImage);
            if (! cardImagePath.isEmpty())
                kard->setCardPath(cardImagePath);
            kard->setCard(m_hands[i][j]);
            kard->flipCard();
            m_messageLayouts[i]->addWidget(kard);
        }

        // Create a qlabel to m_pDisplay the message
        QLabel *qlabel;
        qlabel=new QLabel();
        qlabel->setText(m_messages[i]);
        m_messageLayouts[i]->addWidget(qlabel);
    }

    //Create selecting button.
    m_pBttnOkay=new QPushButton();
    m_pBttnOkay->setText(tr("Okay"));
    m_pBttnOkay->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    // Create the layout of the dialogue
    m_pDisplay=new QVBoxLayout(this);
    for (int i=0, size=m_messageLayouts.size(); i < size; ++i)
        m_pDisplay->addLayout(m_messageLayouts[i]);
    m_pDisplay->addWidget(m_pBttnOkay);
    connect(m_pBttnOkay, SIGNAL(clicked()), this, SLOT(accept()));
}
