/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2008  John Schneiderman <JohnMS@member.fsf.org>                         *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "crazyeightsplayer.h"
#include "aibase.h"

CrazyEightsPlayer::CrazyEightsPlayer(AIBase &aiBase): ComputerPlayer(aiBase), m_rules()
{}

CrazyEightsPlayer::~CrazyEightsPlayer()
{}

Card CrazyEightsPlayer::playCard(const CardSequence& playSequence) const
{
    Card card = m_pAIBase->whichCards("crazy eights SelectCard", playSequence, m_rules, m_hand, m_gameInformation).front();
    return card;
}

Card::Suit CrazyEightsPlayer::selectSuit(const CardSequence& playSequence) const
{
    Card::Suit suit = Card::SUIT_ERR;

    suit = static_cast<Card::Suit>(m_pAIBase->decision("crazy eights SelectSuit", playSequence, m_rules, m_hand, m_gameInformation, m_score));
    return suit;
}
