/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2005-2008  John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#include "cribbageplayer.h"
#include "card.h"
#include "cardsequence.h"
#include "aibase.h"

CribbagePlayer::CribbagePlayer(AIBase &aiBase): ComputerPlayer(aiBase), m_rules()
{}

CribbagePlayer::~CribbagePlayer()
{}

Card CribbagePlayer::playCard(const CardSequence &playSequence) const
{
    if (isTurn())
        return m_pAIBase->whichCards("cribbage", playSequence, m_rules, m_hand, m_gameInformation).front();
    else
        return Card();
}

CardSequence CribbagePlayer::passToCrib()
{
    CardSequence passToCrib;

    if (isDealer())
        passToCrib = m_pAIBase->whichCards("cribbageDealerCrib", CardSequence(), m_rules, m_hand, m_gameInformation);
    else
        passToCrib = m_pAIBase->whichCards("cribbageNonDealerCrib", CardSequence(), m_rules, m_hand, m_gameInformation);
    m_hand.removeCard(passToCrib[1]);
    m_hand.removeCard(passToCrib[0]);
    return passToCrib;
}
