/***************************************************************************************************
*****    This file is part of KardsGT.                                                         *****
*****                                                                                          *****
*****    Copyright (C) 2008       John Schneiderman <JohnMS@member.fsf.org>                    *****
*****                                                                                          *****
*****    This program is free software: you can redistribute it and/or modify it under the     *****
*****    terms of the GNU General Public License as published by the Free Software Foundation, *****
*****    either version 3 of the License, or (at your option) any later version.               *****
*****                                                                                          *****
*****    This program is distributed in the hope that it will be useful, but WITHOUT ANY       *****
*****    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A       *****
*****    PARTICULAR PURPOSE.  See the GNU General Public License for more details.             *****
*****                                                                                          *****
*****    You should have received a copy of the GNU General Public License along with this     *****
*****    program. If not, see <http://www.gnu.org/licenses/>.                                  *****
***************************************************************************************************/
#ifndef PLAYER_SELECTION_H
#define PLAYER_SELECTION_H

#include "ui_playerselection.h"

#include <vector>
using std::vector;

/**
 * This is a dialouge to request that a player selects their opponents for the card game the wish to play.
 *
 * @author John Schneiderman
 */
class PlayerSelection: public QDialog, public Ui::PlayerSelection
{
    Q_OBJECT

public:
    /**
     * The dialogue constructor.
     * @param parent is the parent of this widget.
     */
    PlayerSelection(QWidget *parent);
    /**
     * This gives the player names the user has selected to play with.
     * @return the player's selection.
     */
    vector<QString> selectedPlayers();
    /**
     * This set the boundary conditions for the number of players needed.
     * @param minimum is the minimum number of players needed for the game.
     * @param maximum is the maximum number of players allowed for the game.
     */
    void setPlayersNeeded(int minimum, int maximum);
    /**
     * This sets the game we're selecting players for.
     * @param name is the name of the game we're selecting for.
     */
    void setGameName(const QString &name);

private:
    /// @param m_currentNumberOfPlayers is the current number of players the user has selected.
    int m_currentNumberOfPlayers;
    /// @param m_minimumPlayers is the minimum number of players needed to play the game.
    int m_minimumPlayers;
    /// @param m_maximumPlayers is the maximum number of players needed to play the game.
    int m_maximumPlayers;
    /// @param is the game sentinel that we're selecting players for.
    QString m_gameName;

private slots:
    /**
     * This slot adds the selected player's name to the selected list.
     */
    void addPlayer();
    /**
     * This slot removes the selected player's name from the selected list.
     */
    void removePlayer();
    /**
     * This slot enables the start game button if enough players have been selected.
     */
    void validateNumberOfPlayers();
    /**
     * This slot updates the computer player's image based on the selected name from the list of available players.
     */
    void displayPlayerInfo();
    /**
     * This slot gives information on how to use this dialogue to the user.
     */
    void help();
    /**
     * This slot enables/disables the add and remove buttons based on the players selected in each lists.
     */
    void addRemoveStatus();
};
#endif
