%define name khttrack
%define version 0.10
%define release 1mdk


Summary:   Download a WWW site to a local directory with a Kde Gui.
Name:      %{name}
Version:   %{version}
Release:   %{release}
Copyright: GPL
Url:       http://www.nongnu.org/khttrack

Packager:  Stephane Chapeau <nuscly@ifrance.com>
Group:     Networking/WWW
Source:    %{name}-%{version}.tar.bz2
Requires:	httrack kdelibs
BuildRequires:	kdelibs-devel libjpeg-devel libpng-devel XFree86-devel httrack libopenssl0
BuildRoot: 	%_tmppath/%{name}-buildroot

%description
Khttrack allows you to download a World Wide Web site
from the Internet to a local directory, building recursively all
directories, getting HTML, images, and other files from the server
to your computer. Khttrack arranges the original site
relative link-structure. It support https and partially java and flash.

%prep
%setup
CFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS" ./configure \
                 --disable-rpath \
		    --disable-debug \
		    --prefix=%_prefix \
                $LOCALFLAGS
%build
# Setup for parallel builds
numprocs=`egrep -c ^cpu[0-9]+ /proc/stat || :`
if [ "$numprocs" = "0" ]; then
  numprocs=1
fi

make -j$numprocs

%install
make install-strip DESTDIR=$RPM_BUILD_ROOT

cd $RPM_BUILD_ROOT
find . -type d | sed '1,2d;s,^\.,\%attr(-\,root\,root) \%dir ,' > $RPM_BUILD_DIR/file.list.khttrack
find . -type f | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.khttrack
find . -type l | sed 's,^\.,\%attr(-\,root\,root) ,' >> $RPM_BUILD_DIR/file.list.khttrack

install -d %buildroot/%_menudir/
cat > %buildroot/%_menudir/%{name} <<EOF
?package(%{name}):\
command="%_bindir/khttrack"\
title="Khttrack (WWW Mirror)"\
icon="%{name}.png"\
longtitle="A website downloader"\
needs="x11"\
section="Networking/WWW"
EOF

%post
%update_menus

%postun
%clean_menus

%clean
rm -rf $RPM_BUILD_ROOT/*
rm -rf $RPM_BUILD_DIR/khttrack
rm -rf ../file.list.khttrack


#%files -f ../file.list.khttrack
%files -f ../file.list.khttrack

%defattr(-,root,root)

#%dir %_docdir/HTML/en/khttrack/
#%doc %_docdir/HTML/en/khttrack/*.docbook
#%doc %_docdir/HTML/en/kbiff/*.bz2
#%doc %_docdir/HTML/en/khttrack/common
#%doc %_docdir/HTML/en/khttrack/khttrack.png

%_bindir/*
#%_libdir/*.so
#%_libdir/*.la
#
#%dir %_datadir/apps/%{name}/
#%dir %_datadir/apps/%{name}/pics/
#%_datadir/apps/%{name}/pics/*.png
#
%_datadir/icons/locolor/16x16/*
%_datadir/icons/locolor/32x32/*
#%_datadir/applnk/Internet/khttrack.desktop
%_menudir/*


%changelog
* Sat Jun 7 2003 Stephane CHAPEAU <nuscly@ifrance.com> 10-1mdk
- First Mandrake contrib package


