/***************************************************************************
                          khttrackoptions.h  -  description
                             -------------------
    begin                : Thu Jun 20 2002
    copyright            : (C) 2002 by Stphane Chapeau
    email                : nuscly@ifrance.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KHTTRACKOPTIONS_H
#define KHTTRACKOPTIONS_H

#include <qwidget.h>
#include <option.h>

// manipulation widgets graphiques
#include <qcombobox.h>
#include <qmultilineedit.h>
#include <qlineedit.h>
#include <qradiobutton.h>

#include "khttrackstruct.h"

/**Dialogue des options non fournies dans le wizard
  *@author Stphane Chapeau
  */

class KhttrackOptions : public Options  {
   Q_OBJECT
public: 
	KhttrackOptions(QWidget *parent=0, const char *name=0);
	~KhttrackOptions();

  /** project link */
  KhttrackStruct *project;
  void htmlHelp();
public slots: // Public slots

   void slot_ok();
   void slot_browserID_footer();
   void slot_browserID_identity();
   void slot_build_dosName();
   void slot_build_hidePasswords();
   void slot_build_hideQueryString();
   void slot_build_noErrorPages();
   void slot_build_noExternalPages();
   void slot_build_notPurges();
   void slot_build_personnalStruct();
   void slot_build_siteStructureType();
   void slot_experts_debug();
   void slot_experts_primaryScanRule();
   void slot_experts_rewriteLinks();
   void slot_experts_travelMode();
   void slot_experts_globalTravelMode();
   void slot_experts_useCache();
   void slot_flow_minTransfert();
   void slot_flow_numConnections();
   void slot_flow_removeHostLow();
   void slot_flow_removeTimeOut();
   void slot_flow_retries();
   void slot_flow_timeOut();
   void slot_limits_maxConnexion();
   void slot_limits_maxExtDepth();
   void slot_limits_maxLinks();
   void slot_limits_maxMirrorDepth();
   void slot_limits_maxSizeHTML();
   void slot_limits_maxSizeNonHTML();
   void slot_limits_maxTime();
   void slot_limits_maxTransfer();
   void slot_limits_pauseDownload();
   void slot_limits_siteSize();
   void slot_links_detectAllLinks();
   void slot_links_getHTMLFirst();
   void slot_links_getNonHTML();
   void slot_links_test();
   void slot_log_createLog();
   void slot_log_makeIndex();
   void slot_log_redownload();
   void slot_log_storeAllCache();
   void slot_log_wordDatabase();
   void slot_log_logLevel();
   void slot_proxy_address();
   void slot_proxy_hidePassword();
   void slot_proxy_login();
   void slot_proxy_password();
   void slot_proxy_port();
   void slot_proxy_useFtp();
   void slot_scanRules_filter();
   void slot_scanRules_exclude();
   void slot_scanRules_gif();
   void slot_scanRules_include();
   void slot_scanRules_mov();
   void slot_scanRules_zip();
   void slot_spider_acceptCookies();
   void slot_spider_checkType();
   void slot_spider_notPuges();
   void slot_spider_parseJava();
   void slot_spider_spider();
   void slot_spider_tolerantRequest();
   void slot_spider_updateHacks();
   void slot_spider_http1();
   void stot_mimeType_file01();
   void stot_mimeType_file02();
   void stot_mimeType_file03();
   void stot_mimeType_file04();
   void stot_mimeType_file05();
   void stot_mimeType_file06();
   void stot_mimeType_file07();
   void stot_mimeType_file08();
   void stot_mimeType_file09();
   void stot_mimeType_file10();
   void stot_mimeType_mime01();
   void stot_mimeType_mime02();
   void stot_mimeType_mime03();
   void stot_mimeType_mime04();
   void stot_mimeType_mime05();
   void stot_mimeType_mime06();
   void stot_mimeType_mime07();
   void stot_mimeType_mime08();
   void stot_mimeType_mime09();
   void stot_mimeType_mime10();
   void slot_help();

};

void *pth_htmlhelp(void *threadid);

#endif
