/***************************************************************************
                          launchht.c  -  description
                             -------------------
    begin                : Wed Jul 24 2002
    copyright            : (C) 2002 by Stphane Chapeau
    email                : nuscly@ifrance.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../lib/src/httrack-library.h"
#include "../lib/src/htscore.h"

#include "libwrapper.h"
#include "khttrackmirrorc.h"

/***************************************************/

#if HTS_WIN
#else
#ifndef Sleep
#define Sleep(a) { if (((a)*1000)%1000000) usleep(((a)*1000)%1000000); if (((a)*1000)/1000000) sleep(((a)*1000)/1000000); }
#endif
#endif

////#include "htsglobal.h"
////#include "httrack.h"

// htswrap_add
////#include "htswrap.h"

#if HTS_ANALYSTE_CONSOLE

/* specific definitions */
////#include "htsbase.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#ifdef _WIN32
#include "Winsock.h"
#endif
/* END specific definitions */

// ISO VT100/220 definitions
#define VT_COL_TEXT_BLACK    "30"
#define VT_COL_TEXT_RED      "31"
#define VT_COL_TEXT_GREEN    "32"
#define VT_COL_TEXT_YELLOW   "33"
#define VT_COL_TEXT_BLUE     "34"
#define VT_COL_TEXT_MAGENTA  "35"
#define VT_COL_TEXT_CYAN     "36"
#define VT_COL_TEXT_WHITE    "37"
#define VT_COL_BACK_BLACK    "40"
#define VT_COL_BACK_RED      "41"
#define VT_COL_BACK_GREEN    "42"
#define VT_COL_BACK_YELLOW   "43"
#define VT_COL_BACK_BLUE     "44"
#define VT_COL_BACK_MAGENTA  "45"
#define VT_COL_BACK_CYAN     "46"
#define VT_COL_BACK_WHITE    "47"
//
#define VT_GOTOXY(X,Y)  "\33["Y";"X"f"
#define VT_COLOR(C)     "\33["C"m"
#define VT_RESET        "\33[m"
#define VT_REVERSE      "\33[7m"
#define VT_UNREVERSE    "\33[27m"
#define VT_BOLD         "\33[1m"
#define VT_UNBOLD       "\33[22m"
#define VT_BLINK        "\33[5m"
#define VT_UNBLINK      "\33[25m"
//
#define VT_CLREOL       "\33[K"
#define VT_CLRSOL       "\33[1K"
#define VT_CLRLIN       "\33[2K"
#define VT_CLREOS       "\33[J"
#define VT_CLRSOS       "\33[1J"
#define VT_CLRSCR       "\33[2J"
//
#define csi(X)          printf(s_csi( X ));
void vt_clear(void) {
//  printf("%s%s%s",VT_RESET,VT_CLRSCR,VT_GOTOXY("1","0"));
}
void vt_home(void) {
//  printf("%s%s",VT_RESET,VT_GOTOXY("1","0"));
}
//


/*
#define STYLE_STATVALUES VT_COLOR(VT_COL_TEXT_BLACK)
#define STYLE_STATTEXT   VT_COLOR(VT_COL_TEXT_BLUE)
*/
#define STYLE_STATVALUES VT_BOLD
#define STYLE_STATTEXT   VT_UNBOLD
#define STYLE_STATRESET  VT_UNBOLD
#define NStatsBuffer     14
#define MAX_LEN_INPROGRESS 40

static int use_show;

#endif

/******************************************************/

// Variable globale C
extern char httrackCmd[500][1024];

extern int arretbrutal ;

void *pth_khttrack_main(void *threadid)
{
   khttrack_main();
   pthread_exit(NULL);
}

/*
 * Name:           main
 * Description:    main() function
 * Parameters:     None
 * Should return:  error status
*/
int khttrack_main(void ) {
  /*
     First, ask for an URL
     Note: For the test, option r2 (mirror max depth=1) and --testscan (no index, no cache, do not store, no log files)
  */

//  char _argv[][256] = {"httrack_test" , "http://localhost" , "-O" , "~/websites/testlocal", "" };
  char* argv[]      = {NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL};
  int         argc = 0;

//  while(strlen(_argv[argc])) {
//    argv[argc]=_argv[argc];
  while(strlen(httrackCmd[argc])) {
    argv[argc]=httrackCmd[argc];
    argc++;
  }
  //argc++;
  argv[argc]=NULL;
  //printf("HTTrackLib program\n");

  hts_init();
  htswrap_add("init",httrack_wrapper_init);
  htswrap_add("free",httrack_wrapper_uninit);
  htswrap_add("start",httrack_wrapper_start);
  htswrap_add("change-options",httrack_wrapper_chopt);
  htswrap_add("end",httrack_wrapper_end);
  htswrap_add("check-html",httrack_wrapper_checkhtml);
  htswrap_add("loop",httrack_wrapper_loop);
  htswrap_add("query",httrack_wrapper_query);
  htswrap_add("query2",httrack_wrapper_query2);
  htswrap_add("query3",httrack_wrapper_query3);
  htswrap_add("check-link",httrack_wrapper_check);
  htswrap_add("pause",httrack_wrapper_pause);
  htswrap_add("save-file",httrack_wrapper_filesave);
  htswrap_add("save-name",httrack_wrapper_savename);
  htswrap_add("link-detected",httrack_wrapper_linkdetected);
  htswrap_add("transfer-status",httrack_wrapper_xfrstatus);

/*
  htswrap_add("init",htsshow_init);
  htswrap_add("free",htsshow_uninit);
  htswrap_add("start",htsshow_start);
  htswrap_add("change-options",htsshow_chopt);
  htswrap_add("end",htsshow_end);
  htswrap_add("check-html",htsshow_checkhtml);
  htswrap_add("loop",htsshow_loop);
  htswrap_add("query",htsshow_query);
  htswrap_add("query2",htsshow_query2);
  htswrap_add("query3",htsshow_query3);
  htswrap_add("check-link",htsshow_check);
  htswrap_add("pause",htsshow_pause);
  htswrap_add("save-file",htsshow_filesave);
  htswrap_add("link-detected",htsshow_linkdetected);
  htswrap_add("transfer-status",htsshow_xfrstatus);
  htswrap_add("save-name",htsshow_savename);
*/

  /* Then, launch the mirror */
  hts_main(argc,argv);

  //printf("\nexit httracklib\n");

  /* That's all! */
  return 0;
}
/* CALLBACK FUNCTIONS */

/* Initialize the Winsock */

void __cdecl httrack_wrapper_init(void) {
  //printf("Engine started\n");
//   mirror_info("Engine started");
#ifdef _WIN32
  {
    WORD   wVersionRequested;   // requested version WinSock API
    WSADATA wsadata;            // Windows Sockets API data
    int stat;
    wVersionRequested = 0x0101;
    stat = WSAStartup( wVersionRequested, &wsadata );
    if (stat != 0) {
      printf("Winsock not found!\n");
      return;
    } else if (LOBYTE(wsadata.wVersion) != 1  && HIBYTE(wsadata.wVersion) != 1) {
      printf("WINSOCK.DLL does not support version 1.1\n");
      WSACleanup();
      return;
    }
  }
#endif

}
void __cdecl httrack_wrapper_uninit(void) {
  //printf("Engine exited\n");
  htinfo_mirror_info("Engine exited");
  htcommandend();
#ifdef _WIN32
  WSACleanup();
#endif
}
int __cdecl httrack_wrapper_start(httrackp* opt) {
  htinfo_mirror_info("Started");

  use_show=0;
  if (opt->verbosedisplay==2) {
    use_show=1;
    vt_clear();
  }

  return 1;
}
int __cdecl httrack_wrapper_chopt(httrackp* opt) {
  return __cdecl httrack_wrapper_start(opt);
}
int  __cdecl httrack_wrapper_end(void) {
  htinfo_mirror_info("End of mirror");
  return 1;
}
int __cdecl httrack_wrapper_checkhtml(char* html,int len,char* url_adresse,char* url_fichier) {

  char chaine[1024] ;
  sprintf( chaine, "%s%s", url_adresse,url_fichier);
  //printf("Parsing html file \"%s\": http://%s%s\n",html,url_adresse,url_fichier);
  htinfo_state_url( chaine );
  return 1;
}
int __cdecl httrack_wrapper_loop(void* _back,int back_max,int back_index,int lien_n,int lien_tot,int stat_time,hts_stat_struct* stats) {
/*
int __cdecl htsshow_loop(lien_back* back,int back_max,int back_index,int lien_n,int lien_tot,int stat_time, hts_stat_struct* stats) {    // appel  chaque boucle de HTTrack

/*
  void htinfo_link_detected(char *chaine);
  void htinfo_mirror_info(char *chaine);
  void htinfo_bytes_saved(char *chaine);
  void htinfo_time(char *chaine);
  void htinfo_files_written(char *chaine);
  void htinfo_transfer_rate(char *chaine);
  void htinfo_files_updated(char *chaine);
  void htinfo_active_connections(char *chaine);
  void htinfo_errors(char *chaine);
  void htinfo_state_url1(char *chaine);
  void htinfo_state_url2(char *chaine);
  void htinfo_state_url3(char *chaine);
  void htinfo_state_url4(char *chaine);
  void htinfo_state_url5(char *chaine);
  void htinfo_state_url6(char *chaine);
  void htinfo_state_url7(char *chaine);
  void htinfo_state_url8(char *chaine);
  void htinfo_state_url9(char *chaine);
  void htinfo_state_url10(char *chaine);
  void htinfo_state_url11(char *chaine);
  void htinfo_state_url12(char *chaine);
  void htinfo_state_url13(char *chaine);
  void htinfo_state_url14(char *chaine);
*/



  lien_back* back = (lien_back*)&_back ;
  static TStamp prev_mytime=0;
  static t_InpInfo SInfo;
  //
  TStamp mytime;
  long int rate=0;
  char st[256];
  char chaine_cat[512];
  //
  int stat_written=-1;
  int stat_updated=-1;
  int stat_errors=-1;
  int nbk=-1;
  LLint nb=-1;
  int stat_nsocket=-1;
  LLint stat_bytes=-1;
  LLint stat_bytes_recv=-1;
  int irate=-1;

  /////////////////

  back_max=1;

  //////////////////////:

  ///////////////////////

  if (stats) {
    stat_written=stats->stat_files;
    stat_updated=stats->stat_updated_files;
    stat_errors=stats->stat_errors;
    nbk=stats->nbk;
    stat_nsocket=stats->stat_nsocket;
    irate=(int)stats->rate;
    nb=stats->nb;
    stat_bytes=stats->nb;
    stat_bytes_recv=stats->HTS_TOTAL_RECV;
  }

  if (!use_show)
  {
    puts("Don't use show !");
    return 1;
  }
  mytime=mtime_local();
  if ((stat_time>0) && (stat_bytes_recv>0))
    rate=(int)(stat_bytes_recv/stat_time);
  else
    rate=0;    // pas d'infos

  /* Infos */
  if (stat_bytes>=0) SInfo.stat_bytes=stat_bytes;      // bytes
  if (stat_time>=0) SInfo.stat_time=stat_time;         // time
  if (lien_tot>=0) SInfo.lien_tot=lien_tot; // nb liens
  if (lien_n>=0) SInfo.lien_n=lien_n;       // scanned
  SInfo.stat_nsocket=stat_nsocket;          // socks
  if (rate>0)  SInfo.rate=rate;                // rate
  if (irate>=0) SInfo.irate=irate;             // irate
  if (SInfo.irate<0) SInfo.irate=SInfo.rate;
  if (SInfo.stat_back>=0) SInfo.stat_back=nbk;
  if (stat_written>=0) SInfo.stat_written=stat_written;
  if (stat_updated>=0) SInfo.stat_updated=stat_updated;
  if (stat_errors>=0)  SInfo.stat_errors=stat_errors;


  if ( ((mytime - prev_mytime)>100) || ((mytime - prev_mytime)<0) ) {
    prev_mytime=mytime;


    st[0]='\0';
    qsec2str(st,stat_time);
    //vt_home();
/*
printf(
    VT_GOTOXY("1","1")
    VT_CLREOL
                           STYLE_STATTEXT   "Bytes saved:"
                           STYLE_STATVALUES " \t%s"
                           "\t"
    VT_CLREOL
    VT_GOTOXY("40","1")
                           STYLE_STATTEXT   "Links scanned:"
                           STYLE_STATVALUES " \t%d/%d (+%d)"
    VT_CLREOL"\n"VT_CLREOL
    VT_GOTOXY("1","2")
                           STYLE_STATTEXT   "Time:"
                                            " \t"
                           STYLE_STATVALUES "%s"
                           "\t"
    VT_CLREOL
    VT_GOTOXY("40","2")
                           STYLE_STATTEXT   "Files written:"
                                            " \t"
                           STYLE_STATVALUES "%d"
    VT_CLREOL"\n"VT_CLREOL
    VT_GOTOXY("1","3")
                           STYLE_STATTEXT   "Transfer rate:"
                                            " \t"
                           STYLE_STATVALUES "%s (%s)"
                           "\t"
    VT_CLREOL
    VT_GOTOXY("40","3")
                           STYLE_STATTEXT   "Files updated:"
                                            " \t"
                           STYLE_STATVALUES "%d"
    VT_CLREOL"\n"VT_CLREOL
    VT_GOTOXY("1","4")
                           STYLE_STATTEXT   "Active connections:"
                                            " \t"
                           STYLE_STATVALUES "%d"
                           "\t"
    VT_CLREOL
    VT_GOTOXY("40","4")
                           STYLE_STATTEXT   "Errors:"
                           STYLE_STATVALUES " \t"
                           STYLE_STATVALUES "%d"
    VT_CLREOL"\n"
    STYLE_STATRESET
    ,

      (char*)int2bytes(SInfo.stat_bytes),
      (int)lien_n,(int)SInfo.lien_tot,(int)nbk,
      (char*)st,
      (int)SInfo.stat_written,
      (char*)int2bytessec(SInfo.irate),(char*)int2bytessec(SInfo.rate),
      (int)SInfo.stat_updated,
      (int)SInfo.stat_nsocket,
      (int)SInfo.stat_errors

      );

  */
/*
  void htinfo_link_detected(char *chaine);
  void htinfo_mirror_info(char *chaine);
  void htinfo_bytes_saved(char *chaine);
  void htinfo_time(char *chaine);
  void htinfo_files_written(char *chaine);
  void htinfo_transfer_rate(char *chaine);
  void htinfo_files_updated(char *chaine);
  void htinfo_active_connections(char *chaine);
  void htinfo_errors(char *chaine);

                           STYLE_STATTEXT   "Bytes saved:"
                           STYLE_STATTEXT   "Links scanned:"
                           STYLE_STATTEXT   "Time:"
                           STYLE_STATTEXT   "Files written:"
                           STYLE_STATTEXT   "Transfer rate:"
                           STYLE_STATTEXT   "Files updated:"
                           STYLE_STATTEXT   "Active connections:"
                           STYLE_STATTEXT   "Errors:"

*/
  sprintf(chaine_cat,"%s",(char*)int2bytes(SInfo.stat_bytes));
  htinfo_bytes_saved(chaine_cat);
  sprintf(chaine_cat,"%d/%d (+%d)",(int)lien_n,(int)SInfo.lien_tot,(int)nbk);
  htinfo_link_detected(chaine_cat);
  sprintf(chaine_cat,"%s",(char*)st);
  htinfo_time(chaine_cat);
  sprintf(chaine_cat,"%d",(int)SInfo.stat_written );
  htinfo_files_written(chaine_cat);
  sprintf(chaine_cat,"%s (%s)",(char*)int2bytessec(SInfo.irate),(char*)int2bytessec(SInfo.rate));
  htinfo_transfer_rate(chaine_cat);
  sprintf(chaine_cat,"%d",(int)SInfo.stat_updated );
  htinfo_files_updated(chaine_cat);
  sprintf(chaine_cat,"%d",(int)SInfo.stat_nsocket);
  htinfo_active_connections(chaine_cat);
  sprintf(chaine_cat,"%d",(int)SInfo.stat_errors);
  htinfo_errors(chaine_cat);




// puts("Step1");
    // parcourir registre des liens
    if (back_index>=0) {  // seulement si index pass
      int j,k;
      int index=0;
      int ok=0;         // idem
      int l;            // idem
      //
      t_StatsBuffer StatsBuffer[NStatsBuffer];
// puts("Step2");
      {
        int i;
        for(i=0;i<NStatsBuffer;i++) {
          strcpy(StatsBuffer[i].state,"");
          strcpy(StatsBuffer[i].name,"");
          strcpy(StatsBuffer[i].file,"");
          strcpy(StatsBuffer[i].url_sav,"");
          StatsBuffer[i].back=0;
          StatsBuffer[i].size=0;
          StatsBuffer[i].sizetot=0;
        }
      }
//puts("Step3");
      for(k=0;k<2;k++) {    // 0: lien en cours 1: autres liens
        for(j=0;(j<3) && (index<NStatsBuffer);j++) {  // passe de priorit
          int _i;
          for(_i=0+k;(_i< max(back_max*k,1) ) && (index<NStatsBuffer);_i++) {  // no lien
            int i=(back_index+_i)%back_max;    // commencer par le "premier" (l'actuel)
//puts("step4");
//printf("k=%d,i=%d(back_index=%d+_i=%d)%back_max=%d",k,i,back_index,_i,back_max);
            if (back[i].status>=0) {     // signifie "lien actif"

//puts("step5");
              // int ok=0;  // OPTI
              ok=0;
              switch(j) {
              case 0:     // prioritaire
                if ((back[i].status>0) && (back[i].status<99)) {
                  strcpy(StatsBuffer[index].state,"receive"); ok=1;
                }
                break;
              case 1:
                if (back[i].status==99) {
                  strcpy(StatsBuffer[index].state,"request"); ok=1;
                }
                else if (back[i].status==100) {
                  strcpy(StatsBuffer[index].state,"connect"); ok=1;
                }
                else if (back[i].status==101) {
                  strcpy(StatsBuffer[index].state,"search"); ok=1;
                }
                else if (back[i].status==1000) {    // ohh le beau ftp
                  sprintf(StatsBuffer[index].state,"ftp: %s",back[i].info); ok=1;
                }
                break;
              default:
                if (back[i].status==0) {  // prt
                  if ((back[i].r.statuscode==200)) {
                    strcpy(StatsBuffer[index].state,"ready"); ok=1;
                  }
                  else if ((back[i].r.statuscode>=100) && (back[i].r.statuscode<=599)) {
                    char tempo[256]; tempo[0]='\0';
                    infostatuscode(tempo,back[i].r.statuscode);
                    strcpy(StatsBuffer[index].state,tempo); ok=1;
                  }
                  else {
                    strcpy(StatsBuffer[index].state,"error"); ok=1;
                  }
                }
                break;
              }
//puts("step6");
              if (ok) {
                char s[HTS_URLMAXSIZE*2];
                //
                StatsBuffer[index].back=i;        // index pour + d'infos
                //
                s[0]='\0';
                strcpy(StatsBuffer[index].url_sav,back[i].url_sav);   // pour cancel
                if (strcmp(back[i].url_adr,"file://"))
                  strcat(s,back[i].url_adr);
                else
                  strcat(s,"localhost");
                if (back[i].url_fil[0]!='/')
                  strcat(s,"/");
                strcat(s,back[i].url_fil);

                StatsBuffer[index].file[0]='\0';
                {
                  char* a=strrchr(s,'/');
                  if (a) {
                    strncat(StatsBuffer[index].file,a,200);
                    *a='\0';
                  }
                }
//puts("step7");
                if ((l=strlen(s))<MAX_LEN_INPROGRESS)
                  strcpy(StatsBuffer[index].name,s);
                else {
                  // couper
                  StatsBuffer[index].name[0]='\0';
                  strncat(StatsBuffer[index].name,s,MAX_LEN_INPROGRESS/2-2);
                  strcat(StatsBuffer[index].name,"...");
                  strcat(StatsBuffer[index].name,s+l-MAX_LEN_INPROGRESS/2+2);
                }

                if (back[i].r.totalsize>0) {  // taille prdfinie
                  StatsBuffer[index].sizetot=back[i].r.totalsize;
                  StatsBuffer[index].size=back[i].r.size;
                } else {  // pas de taille prdfinie
                  if (back[i].status==0) {  // prt
                    StatsBuffer[index].sizetot=back[i].r.size;
                    StatsBuffer[index].size=back[i].r.size;
                  } else {
                    StatsBuffer[index].sizetot=8192;
                    StatsBuffer[index].size=(back[i].r.size % 8192);
                  }
                }
                index++;
              }
            }
          }
        }
      }

      /* LF */
      //printf("%s\n",VT_CLREOL);

      /* Display current job */
      {
        int parsing=0;
        //printf("Current job: ");
        if ((parsing=hts_is_parsing(-1)))
        {
          switch(hts_is_testing()) {
          case 0:
            //printf("parsing HTML file (%d%%)",parsing);
            break;
          case 1:
            //printf("parsing HTML file: testing links (%d%%)",parsing);
            break;
          case 2:
            //printf("purging files");
            break;
          }
        }
        //printf("%s\n",VT_CLREOL);
      }

      /* Display background jobs */
      {
        int i;
        for(i=0;i<NStatsBuffer;i++) {
          if (strnotempty(StatsBuffer[i].state)) {
            /*printf(VT_CLREOL" %s - \t%s%s \t%s / \t%s",
              StatsBuffer[i].state,
              StatsBuffer[i].name,
              StatsBuffer[i].file,
              int2bytes(StatsBuffer[i].size),
              int2bytes(StatsBuffer[i].sizetot)
              );*/
          }
          //printf("%s\n",VT_CLREOL);
        }

        i=0;
        //if (strnotempty(StatsBuffer[i].state)) {
          sprintf(chaine_cat," %s - \t%s%s \t%s / \t%s",
             StatsBuffer[i].state,
             StatsBuffer[i].name,
             StatsBuffer[i].file,
             int2bytes(StatsBuffer[i].size),
             int2bytes(StatsBuffer[i].sizetot)
          );
        //htinfo_state_url1(chaine_cat);
        //}


      }


    }

  }



  return arretbrutal;
}
char* __cdecl httrack_wrapper_query(char* question) {
//char* __cdecl htsshow_query(char* question) {
//  static char s[12]="";
  printf("%s\nPress <Y><Enter> to confirm, <N><Enter> to abort Q1\n",question);
//  io_flush; linput(stdin,s,4);
//  return s;
//  return "N" ;
    htquestion1();
}
char* __cdecl httrack_wrapper_query2(char* question) {
//char* __cdecl htsshow_query2(char* question) {
//  static char s[12]="";
  printf("%s\nPress <Y><Enter> to confirm, <N><Enter> to abort Q2\n",question);
//  io_flush; linput(stdin,s,4);
//  return s;
//  return htquestion2();

  return "N";

}
char* __cdecl httrack_wrapper_query3(char* question) {
/*  static char line[256];
  do {
    io_flush; linput(stdin,line,206);
  } while(!strnotempty(line));
*///  printf("ok..\n");
//  return line;
//  return "N";
  return htquestion3();
}
int __cdecl httrack_wrapper_check(char* adr,char* fil,int status) {
/* testprgm** printf("Link status tested: http://%s%s\n",adr,fil);
   mirror_testc("Link status tested"); */
  return -1;
}
void __cdecl httrack_wrapper_pause(char* lockfile) {
//void __cdecl htsshow_pause(char* lockfile) {
  while (fexist(lockfile)) {
    Sleep(1000);
  }

}
void __cdecl httrack_wrapper_filesave(char* file) {
}
int __cdecl httrack_wrapper_linkdetected(char* link) {
  return 1;
}
int __cdecl httrack_wrapper_xfrstatus(void* back) {
  return 1;
}
int __cdecl httrack_wrapper_savename(char* adr_complete,char* fil_complete,char* referer_adr,char* referer_fil,char* save) {
  return 1;
}
/***************   C in C++ Doc  *************************************

> The linker error I get is:
> > undefined symbol "run" in file such and such, ect, ect.
> > I have the run function defined in my .cc file, and it is being called
> from my .c file. The .c file has the correct prototype for the run
> function but is unable to find it in the .cc file on link. If anyone
> has any ideas, lets me know..

The names of C++ functions are "mangled" to include information about
the types of the the function's arguments.  To use C functions from C++
source or vice versa, they must be declared extern "C".  You can group
these with extern "C" { ... }

If you look at the standard header files, you will see things like

#ifdef __cplusplus
extern "C" {
#endif

[declarations of C functions]

#ifdef __cplusplus
}
#endif


or, more cleanly, define in some common header file

#ifdef __cplusplus
#define BEGIN_C_DECLS extern "C" {
#define END_C_DECLS }
#else
#define BEGIN_C_DECLS
#define END_C_DECLS
#endif

and then

BEGIN_C_DECLS

[declarations of C functions]

END_C_DECLS



You should follow a similar strategy in the header files
for your project.  Make sure that every global function
is declared in one of those header files, and that the
appropriate header files are included.  Every function which
is defined or used in C code must be declared extern "C".
Try not to do so for functions that are only used in C++ code,
since that will lose type-safe chacks, but it should otherwise be
harmless.  As long as every global function is declared in a header
file and each header file is always included in every file that uses
any functions from it, the link should succeed.  (These are basic
principles of C/C++ engineering, regardless of whether you are
merging the two).

*/

