/* -*- c++ -*-
 *
 * appletconfig.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __appletconfig_h__
#define __appletconfig_h__

#include <kdialogbase.h>

class KListBox;
class KPushButton;
class QCheckBox;
class KIntNumInput;

class AppletConfig : public KDialogBase
{
    Q_OBJECT

public:
    AppletConfig(QWidget* parent = 0, const char* name = 0);
    ~AppletConfig();

    void setActive(const QStringList& list);
    QStringList active();

    QCheckBox* showLabelsSelect;
    QCheckBox* showDoubleSelect;
    QCheckBox* showMuteSelect;
    KListBox* availableBox;
    KListBox* activeBox;
    KPushButton* upButton;
    KPushButton* leftButton;
    KPushButton* downButton;
    KPushButton* rightButton;
    KIntNumInput* normalUploadEntry;
    KIntNumInput* normalDownloadEntry;
    KIntNumInput* muteUploadEntry;
    KIntNumInput* muteDownloadEntry;

    QMap<QString,QString> itemTitles;
    QMap<QString,QString> itemTooltips;

private slots:
    void moveLeft();
    void moveRight();
    void moveUp();
    void moveDown();

private:
    void insertItem(KListBox* box, const QString& name);

    QMap<QString,QString> itemNames;

};

#endif
