/* -*- c++ -*-
 *
 * kcmdonkey.h
 *
 * Copyright (C) 2002 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kcmdonkey_kcmdonkey_h__
#define __kcmdonkey_kcmdonkey_h__

#include <qvariant.h>
#include <qwidget.h>
#include <qlistbox.h>
#include <kcmodule.h>

class KAboutData;
class MobileMuleConfig;

class DonkeyEntry : public QListBoxText
{
public:
    DonkeyEntry(QListBox* box, const QString& name, const QString& address,
		int telnetPort, int guiPort, const QString& username, const QString& password,
		bool isLocal = false, const QString& temp = 0, const QString& incoming = 0,
		bool isDefault = false);

    const QString& getName() { return m_name; }
    const QString& getAddress() { return m_address; }
    int getTelnetPort() { return m_telnetPort; }
    int getGuiPort() { return m_guiPort; }
    const QString& getUsername() { return m_username; }
    const QString& getPassword() { return m_password; }
    bool getLocalMode() { return m_local; }
    const QString& getTemp() { return m_temp; }
    const QString& getIncoming() { return m_incoming; }
    bool getDefault() { return m_default; }

    void setName(const QString& name);
    void setAddress(const QString& address) { m_address = address; }
    void setTelnetPort(int port) { m_telnetPort = port; }
    void setGuiPort(int port) { m_guiPort = port; }
    void setUsername(const QString& username) { m_username = username; }
    void setPassword(const QString& password) { m_password = password; }
    void setLocalMode(bool local) { m_local = local; }
    void setTemp(const QString& temp) { m_temp = temp; }
    void setIncoming(const QString& incoming) { m_incoming = incoming; }
    void setDefault(bool isDefault);

private:
    QString m_name, m_address, m_username, m_password, m_temp, m_incoming;
    int m_telnetPort, m_guiPort;
    bool m_default, m_local;
};

class KCMDonkey : public KCModule
{
    Q_OBJECT

public:
    KCMDonkey( QWidget *parent=0, const char *name=0 );
    ~KCMDonkey();

    virtual void load();
    virtual void save();
    virtual void defaults();
    virtual int buttons();
    virtual QString quickHelp() const;
    virtual const KAboutData *aboutData() const;
    
public slots:
    void configChanged();

protected slots:
    void entrySelected(QListBoxItem*);
    void nameChanged(const QString&);
    void addressChanged(const QString&);
    void usernameChanged(const QString&);
    void passwordChanged(const QString&);
    void telnetPortChanged(int);
    void guiPortChanged(int);
    void localModeChanged(bool);
    void tempChanged(const QString&);
    void incomingChanged(const QString&);
    void defaultButtonClicked();
    void newButtonClicked();
    void deleteButtonClicked();
    void tempPathDialog();
    void incomingPathDialog();

private:
    void setDefaultEntry(DonkeyEntry* entry);
    DonkeyEntry* getActiveEntry();
    bool startMobileMuleService(bool start);

    KConfig* m_pConfig;
    
    MobileMuleConfig* mm;

    KListBox* hostList;
    QLabel* telnetPortLabel;
    KLineEdit* nameEntry;
    QLabel* addressLabel;
    QLabel* guiPortLabel;
    KLineEdit* addressEntry;
    KIntNumInput* telnetPortEntry;
    KIntNumInput* guiPortEntry;
    KLineEdit* usernameEntry;
    QLabel* passwordLabel;
    QLabel* nameLabel;
    KPasswordEdit* passwordEntry;
    QLabel* usernameLabel;
    KPushButton* defaultButton;
    KPushButton* newButton;
    KPushButton* deleteButton;
    QCheckBox* localMode;
    KLineEdit* tempPath;
    KLineEdit* incomingPath;

    DonkeyEntry* defaultEntry;
    DonkeyEntry* activeEntry;

    bool processSignals;
};

#endif
