/* -*- c++ -*-
 *
 * mlconfig.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_mlconfig_h__
#define __kmldonkey_mlconfig_h__

#include <qdict.h>
#include <kdialogbase.h>

class OptionEditorWidget;
class QCheckBox;

class NetworkPage : public QWidget
{
    Q_OBJECT
public:
    NetworkPage(QWidget* parent = 0, const char* name = 0);

    void applyOptions(DonkeyProtocol* target);

protected slots:
    void becomeDirty(bool);

signals:
    void pageDirty();

private:
    QIntDict<QCheckBox> nwBox;
};

class MLDonkeyConfigDialog : public KDialogBase
{
    Q_OBJECT
public:
    MLDonkeyConfigDialog(QWidget* parent = 0, const char* name = 0);

protected slots:
    void setDirtyDialog();
    void slotApply();
    void slotOk();
    void slotDefault();
    void closeDialog();

private:
    QDict<OptionEditorWidget> pages;
    NetworkPage* m_networkPage;
};

#endif // __kmldonkey_mlconfig_h__
