/* -*- c++ -*-
 *
 * serverpage.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_serverpage_h__
#define __kmldonkey_serverpage_h__

#include <qobject.h>
#include <qvbox.h>
#include <qintdict.h>

#include "clipboard.h"
#include "page.h"

class KActionCollection;

class KMLDonkeyPrefs;
class InfoList;

class ServerPage : public QVBox, public KMLDonkeyPage, public ClipboardHelper
{
    Q_OBJECT
public:
    ServerPage(QWidget* parent = 0);

    virtual void setupActions(KActionCollection*);
    virtual QStringList supportedGenericActions();
    virtual void handleGenericAction(const QString&);
    virtual void plugGenericActions(QObject*, const char*);
    virtual void deactivatePageActions();

    virtual void configurePrefsDialog(KMLDonkeyPreferences* prefs);
    virtual void applyPreferences(KMLDonkeyPreferences* prefs = 0);
    virtual void saveState(KConfig* conf);
    virtual void restoreState(KConfig* conf);

    virtual void clear();

    KToggleAction *showAllServersAction;

signals:
    void genericActionsChanged(KMLDonkeyPage*);

public slots:
    void serverUpdated(int server);
    void serverRemoved(int server);

protected slots:
    void contextServer(KListView*,QListViewItem*,const QPoint&);

    void actionConnectServer();
    void actionConnectMoreServers();
    void actionDisconnectServer();
    void actionAddServer();
    void actionRemoveServer();
    void actionRemoveOldServers();
    void actionServerCopyURL();
    void actionServerCopyHTML();
    void actionShowAllServers(bool show);

    void actionActivatePage();

    void pleaseUpdateActions();

    void networkUpdated(int);

protected:
    void copyServerToClipboard(QPtrList<ServerInfo>& servers, ClipFormat format);

private:
    InfoList *serverView;
    QIntDict<ServerInfoItem> serverItemList;
    QPtrList<KAction> serverActions;

    KAction* m_addServerAction;
};

#endif
