/* -*- c++ -*-
 *
 * giftprotocol.h
 *
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __libkmldonkey_giftprotocol_h__
#define __libkmldonkey_giftprotocol_h__

#include <qstring.h>
#include <qobject.h>
#include <qsocket.h>
#include <kdebug.h>

#include "protocoliface.h"
#include "giftsocket.h"
#include "giftmessage.h"

/* Maybe used for statistics and such stuff in future giFT-releases */
#define GIFT_CLIENT_NAME "kmldonkey"
#define GIFT_CLIENT_VERSION "1"

class GiftProtocol : public ProtocolInterface
{
    Q_OBJECT
public:
    GiftProtocol(QObject *parent);
    ~GiftProtocol();

    //! Get if the socket is connected
    /*!
     * \return socket is connected (true) or disconnected (false)
     */
    bool isConnected();

    //! (Re-)Connect to the core.
    /*!
     * Initiate a connection to the core.
     */
    bool connectToCore();

    //! Disconnect from the core.
    /*!
     * Initiate a disconnection from the core. The signal signalDisconnected(int)
     * will be emitted when the disconnect is complete.
     */
    bool disconnectFromCore();

    //! Send a messagestring to the core.
    /*!
     * \param message a giFT-messagestring, see http://gift.sourceforge.net/docs.php?document=interface.html
     */
    bool sendMessageToCore(const QString& message);

    //! Send a GiftMessage to the core.
    /*!
     * This function is similar to the sendMessageToCore(const QString& message) above
     * except that it does expect a GiftMessage-instance as parameter.
     * \param message a GiftMessage-instance containing the message which should be send
     */
    bool sendMessageToCore(GiftMessage* message);

private slots:
    void socketReadReady();
    void socketDisconnected();
    void socketError(int err);

private:
    giFTSocket sock;
    int giftError;

    // The name of the server, this will be 'giFT'.
    QString giftServerName;
    // giFT's version. This can be important if certain parts of this protocol change, and you want your client to support it.
    QString giftServerVersion;

    GiftMessage* message;
};

#endif
