/* -*- c++ -*-
 *
 * hostiface.h
 *
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __libkmldonkey_hostiface_h__
#define __libkmldonkey_hostiface_h__

#include <qstring.h>

/* Base class for all hosts. DonkeyHost and GiftHost are inherited from
 * this class as example.
 */
class HostInterface
{
public:
    enum enumHostType {
        typeUnknown = 0,
        typeLocal,
        typeRemote
    };

    HostInterface(QString h_name = QString::null,
                  QString h_address = QString::null,
                  int h_port = 0,
                  enumHostType h_type = typeUnknown) {
        setName(h_name);
        setAddress(h_address);
        setPort(h_port);
        m_type = h_type;
    }
    virtual ~HostInterface() {}

    //! The host ID (descriptive name) of the host.
    virtual const QString& name() { return m_name; }
    virtual void setName(const QString& h_name) { m_name = h_name; }

    //! The network address of the host.
    virtual const QString& address() const { return m_address; }
    virtual void setAddress(const QString& h_address) { m_address = h_address.stripWhiteSpace(); }

    //! The (GUI-) port used to communicate with the core
    virtual const int guiPort() { return m_port; }
    virtual void setPort(const int h_port) { m_port = h_port; }

    //! Whether this is a local host.
    virtual const bool localHost() {
        if(m_type == typeUnknown) // if unknown let's try to guess it from the given address
            return (m_address == "127.0.0.1" || m_address.lower() == "localhost");
        return m_type == typeLocal;
    }
    virtual void setType(enumHostType h_type) { m_type = h_type; }

private:
    QString m_name,
            m_address;
    int m_port;

    enumHostType m_type;
};

#endif
