/* -*- c++ -*-
 *
 * options.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "donkeymessage.h"
#include "options.h"

#include <kdebug.h>

DonkeyOption::DonkeyOption(DonkeyMessage* msg, int proto)
{
    section = msg->readString();
    label = msg->readString();
    name = msg->readString();
    if (proto > 16) {
	type = msg->readString();
	help = msg->readString();
	value = msg->readString();
	defaultValue = msg->readString();
	advanced = msg->readBool();
    } else {
	switch (msg->readInt8()) {
	case 1: type = "Bool"; break;
	default: type = "String"; break;
	}
	advanced = false;
    }
}

DonkeyOption::DonkeyOption(const DonkeyOption& o)
{
    section = o.optionSection();
    label = o.optionLabel();
    name = o.optionName();
    type = o.optionType();
    help = o.optionHelp();
    value = o.optionValue();
    defaultValue = o.optionDefaultValue();
    advanced = o.optionAdvanced();
}

DonkeyOption::~DonkeyOption()
{
}

const QString& DonkeyOption::optionSection() const { return section; }
const QString& DonkeyOption::optionLabel() const { return label; }
const QString& DonkeyOption::optionName() const { return name; }
const QString& DonkeyOption::optionType() const { return type; }
const QString& DonkeyOption::optionHelp() const { return help; }
const QString& DonkeyOption::optionValue() const { return value; }
const QString& DonkeyOption::optionDefaultValue() const { return defaultValue; }
bool DonkeyOption::optionAdvanced() const { return advanced; }

