/* -*- c++ -*-
 *
 * serverinfo.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "serverinfo.h"
#include "donkeymessage.h"



ServerInfo::ServerInfo(DonkeyMessage* msg, int proto)
{
    int i,j;
    num = msg->readInt32();
    network = msg->readInt32();
    address = msg->readAddress();
    port = msg->readInt16();
    score = msg->readInt32();
    j = msg->readInt16();
    tags.clear();
    for (i=0; i<j; i++)
	msg->readTag(tags);
    nusers = msg->readInt32();
    nfiles = msg->readInt32();
    updateServerState(msg, proto);
    name = msg->readString();
    description = msg->readString();
}

ServerInfo::ServerInfo(const ServerInfo& si)
{
    num = si.serverNo();
    name = si.serverName();
    network = si.serverNetwork();
    description = si.serverDescription();
    address = si.serverAddress();
    port = si.serverPort();
    score = si.serverScore();
    nusers = si.serverNUsers();
    nfiles = si.serverNFiles();
    state = si.serverState();
    tags = si.serverTags();
}

ServerInfo::~ServerInfo()
{
}

void ServerInfo::updateServerState(DonkeyMessage* msg, int proto)
{
    state = (State)msg->readInt8();
    if (proto >= 12 && (state == 5 || state == 9)) msg->readInt32();
}

const int ServerInfo::serverNo() const
{
    return num;
}

const QString& ServerInfo::serverName() const
{
    return name;
}

const int ServerInfo::serverNetwork() const
{
    return network;
}

const QString& ServerInfo::serverDescription() const
{
    return description;
}

const QString& ServerInfo::serverAddress() const
{
    return address;
}

const short int ServerInfo::serverPort() const
{
    return port;
}

const int ServerInfo::serverScore() const
{
    return score;
}

const int ServerInfo::serverNUsers() const
{
    return nusers;
}

const int ServerInfo::serverNFiles() const
{
    return nfiles;
}

const ServerInfo::State ServerInfo::serverState() const
{
    return state;
}

const QMap<QString,QVariant>& ServerInfo::serverTags() const
{
    return tags;
}
