/* -*- c++ -*-
 *
 * appletconfig.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include <klocale.h>
#include <kpushbutton.h>
#include <knuminput.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qhbox.h>
#include <kfontdialog.h>


#include "appletconfig.h"
#include "appletconfig.moc"

AppletConfig::AppletConfig(QWidget* parent, const char* name)
    : KDialogBase(parent, name, true, i18n("MLDonkey Applet Configuration"))
{
    if ( !name )
	setName( "AppletConfig" );

    QFrame* frame = new QFrame(this);
    QVBoxLayout* AppletConfigLayout = new QVBoxLayout( frame, 11, 6, "AppletConfigLayout");

    QGroupBox* groupBox2 = new QGroupBox( frame, "groupBox2" );
    groupBox2->setTitle(i18n("Layout"));
    groupBox2->setColumnLayout(0, Qt::Vertical );
    groupBox2->layout()->setSpacing( 6 );
    groupBox2->layout()->setMargin( 11 );
    QVBoxLayout* groupBox2Layout = new QVBoxLayout( groupBox2->layout() );
    groupBox2Layout->setAlignment( Qt::AlignTop );

    showLabelsSelect = new QCheckBox( groupBox2, "showLabelsSelect" );
    showLabelsSelect->setText(i18n("Show status display labels"));
    groupBox2Layout->addWidget( showLabelsSelect );

    showDoubleSelect = new QCheckBox( groupBox2, "showDoubleSelect" );
    showDoubleSelect->setText(i18n("...but only in double row mode"));
    showDoubleSelect->setEnabled( FALSE );
    groupBox2Layout->addWidget( showDoubleSelect );

    showMuteSelect = new QCheckBox( groupBox2, "showMuteSelect" );
    showMuteSelect->setText(i18n( "Show mute button in single row mode"));
    groupBox2Layout->addWidget( showMuteSelect );
    AppletConfigLayout->addWidget( groupBox2 );

    QHBox* fontBox = new QHBox( groupBox2, "FontChooser" );
    groupBox2Layout->addWidget( fontBox );
    new QLabel(i18n("Applet font:"), fontBox);
    fontpreview = new QLabel(fontBox);
    fontpreview->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
    fontpreview->setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed,
                                           0, 0, fontpreview->sizePolicy().hasHeightForWidth()));
    KPushButton* fontButton = new KPushButton(i18n("Choose..."), fontBox);
    fontButton->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Fixed);
    connect(fontButton, SIGNAL(clicked()), this, SLOT(selectAppletFont()));

    QGroupBox* groupBox1 = new QGroupBox( frame, "groupBox1" );
    groupBox1->setTitle(i18n("Status Displays"));
    groupBox1->setColumnLayout(0, Qt::Vertical );
    groupBox1->layout()->setSpacing( 6 );
    groupBox1->layout()->setMargin( 11 );
    QHBoxLayout* groupBox1Layout = new QHBoxLayout( groupBox1->layout() );
    groupBox1Layout->setAlignment( Qt::AlignTop );

    QVBoxLayout* layout2 = new QVBoxLayout( 0, 0, 6, "layout2");

    QLabel* textLabel1 = new QLabel(i18n("Available"), groupBox1, "textLabel1" );
    textLabel1->setAlignment( int( QLabel::AlignCenter ) );
    layout2->addWidget( textLabel1 );

    availableBox = new KListBox( groupBox1, "availableBox" );
    layout2->addWidget( availableBox );
    groupBox1Layout->addLayout( layout2 );

    QVBoxLayout* layout4 = new QVBoxLayout( 0, 0, 6, "layout4");
    QSpacerItem* spacer = new QSpacerItem( 0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout4->addItem( spacer );

    QGridLayout* layout3 = new QGridLayout( 0, 1, 1, 0, 6, "layout3");

    upButton = new KPushButton(KGuiItem(QString::null, "1uparrow", i18n("Move the selected item up")), groupBox1, "upButton" );
    upButton->setSizePolicy( QSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed, 0, 0, upButton->sizePolicy().hasHeightForWidth() ) );

    layout3->addWidget( upButton, 0, 1 );

    leftButton = new KPushButton(KGuiItem(QString::null, "1leftarrow", i18n("Move the selected item left")), groupBox1, "leftButton" );
    leftButton->setSizePolicy( QSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed, 0, 0, leftButton->sizePolicy().hasHeightForWidth() ) );

    layout3->addWidget( leftButton, 1, 0 );

    downButton = new KPushButton(KGuiItem(QString::null, "1downarrow", i18n("Move the selected item down")), groupBox1, "downButton" );
    downButton->setSizePolicy( QSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed, 0, 0, downButton->sizePolicy().hasHeightForWidth() ) );

    layout3->addWidget( downButton, 2, 1 );

    rightButton = new KPushButton(KGuiItem(QString::null, "1rightarrow", i18n("Move the selected item right")), groupBox1, "rightButton" );
    rightButton->setSizePolicy( QSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed, 0, 0, rightButton->sizePolicy().hasHeightForWidth() ) );

    layout3->addWidget( rightButton, 1, 2 );
    layout4->addLayout( layout3 );
    QSpacerItem* spacer_2 = new QSpacerItem( 0, 0, QSizePolicy::Minimum, QSizePolicy::Expanding );
    layout4->addItem( spacer_2 );
    groupBox1Layout->addLayout( layout4 );

    QVBoxLayout* layout1 = new QVBoxLayout( 0, 0, 6, "layout1");

    QLabel* textLabel2 = new QLabel(i18n("Active"), groupBox1, "textLabel2" );
    textLabel2->setAlignment( int( QLabel::AlignCenter ) );
    layout1->addWidget( textLabel2 );

    activeBox = new KListBox( groupBox1, "activeBox" );
    layout1->addWidget( activeBox );
    groupBox1Layout->addLayout( layout1 );
    AppletConfigLayout->addWidget( groupBox1 );

    QGroupBox* groupBox3 = new QGroupBox( frame, "groupBox3" );
    groupBox3->setTitle(i18n("Mute"));
    groupBox3->setColumnLayout(0, Qt::Vertical );
    groupBox3->layout()->setSpacing( 6 );
    groupBox3->layout()->setMargin( 11 );
    QGridLayout* groupBox3Layout = new QGridLayout( groupBox3->layout() );
    groupBox3Layout->setAlignment( Qt::AlignTop );

    normalUploadEntry = new KIntNumInput( groupBox3, "normalUploadEntry" );
    normalUploadEntry->setMinValue( 0 );
    groupBox3Layout->addWidget( normalUploadEntry, 1, 1 );

    normalDownloadEntry = new KIntNumInput( groupBox3, "normalDownloadEntry" );
    normalDownloadEntry->setMinValue( 0 );
    groupBox3Layout->addWidget( normalDownloadEntry, 1, 2 );

    muteUploadEntry = new KIntNumInput( groupBox3, "muteUploadEntry" );
    muteUploadEntry->setValue( 4 );
    muteUploadEntry->setMinValue( 0 );
    groupBox3Layout->addWidget( muteUploadEntry, 2, 1 );

    muteDownloadEntry = new KIntNumInput( groupBox3, "muteDownloadEntry" );
    muteDownloadEntry->setValue( 4 );
    muteDownloadEntry->setMinValue( 0 );
    groupBox3Layout->addWidget( muteDownloadEntry, 2, 2 );

    normalUploadEntry->setSuffix( i18n( " Kb/s" ) );
    QToolTip::add( normalUploadEntry, i18n( "Upload speed in normal mode" ) );
    normalDownloadEntry->setSuffix( i18n( " Kb/s" ) );
    QToolTip::add( normalDownloadEntry, i18n( "Download speed in normal mode" ) );
    muteUploadEntry->setSuffix( i18n( " Kb/s" ) );
    QToolTip::add( muteUploadEntry, i18n( "Upload speed in mute mode" ) );
    muteDownloadEntry->setSuffix( i18n( " Kb/s" ) );
    QToolTip::add( muteDownloadEntry, i18n( "Download speed in mute mode" ) );

    QLabel* textLabel4 = new QLabel(i18n("Mute:"), groupBox3, "textLabel4" );
    textLabel4->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, textLabel4->sizePolicy().hasHeightForWidth() ) );
    groupBox3Layout->addWidget( textLabel4, 2, 0 );

    QLabel* textLabel3 = new QLabel(i18n("Normal:"), groupBox3, "textLabel3" );
    textLabel3->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, textLabel3->sizePolicy().hasHeightForWidth() ) );
    groupBox3Layout->addWidget( textLabel3, 1, 0 );

    QLabel* textLabel1_2 = new QLabel(i18n("Upload"), groupBox3, "textLabel1_2" );
    textLabel1_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, 0, 0, textLabel1_2->sizePolicy().hasHeightForWidth() ) );
    groupBox3Layout->addWidget( textLabel1_2, 0, 1 );

    QLabel* textLabel2_2 = new QLabel(i18n("Download"), groupBox3, "textLabel2_2" );
    textLabel2_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)0, 0, 0, textLabel2_2->sizePolicy().hasHeightForWidth() ) );
    groupBox3Layout->addWidget( textLabel2_2, 0, 2 );

    AppletConfigLayout->addWidget( groupBox3 );

    setMainWidget(frame);

    resize( QSize(600, 452).expandedTo(minimumSizeHint()) );

    // signals and slots connections
    connect( showLabelsSelect, SIGNAL( toggled(bool) ), showDoubleSelect, SLOT( setEnabled(bool) ) );

    // tab order
    setTabOrder( showLabelsSelect, showDoubleSelect );
    setTabOrder( showDoubleSelect, showMuteSelect );
    setTabOrder( showMuteSelect, availableBox );
    setTabOrder( availableBox, upButton );
    setTabOrder( upButton, downButton );
    setTabOrder( downButton, leftButton );
    setTabOrder( leftButton, rightButton );
    setTabOrder( rightButton, activeBox );

    itemTitles.insert("speed", i18n("Speed"));
    itemTitles.insert("files", i18n("Files"));
    itemTitles.insert("shared", i18n("Shared"));
    itemTitles.insert("transfer", i18n("Transferred"));
    itemTooltips.insert("speed", i18n("Current bandwidth usage upload/download"));
    itemTooltips.insert("files", i18n("Files completed/downloading"));
    itemTooltips.insert("shared", i18n("Shared files/bytes"));
    itemTooltips.insert("transfer", i18n("Total transferred bytes upload/download"));
    QMap<QString,QString>::Iterator it;
    for (it = itemTitles.begin(); it != itemTitles.end(); ++it)
	itemNames.insert(it.data(), it.key());

    connect(upButton, SIGNAL(clicked()), this, SLOT(moveUp()));
    connect(downButton, SIGNAL(clicked()), this, SLOT(moveDown()));
    connect(leftButton, SIGNAL(clicked()), this, SLOT(moveLeft()));
    connect(rightButton, SIGNAL(clicked()), this, SLOT(moveRight()));
}

/*
 *  Destroys the object and frees any allocated resources
 */
AppletConfig::~AppletConfig()
{
    // no need to delete child widgets, Qt does it all for us
}



void AppletConfig::insertItem(KListBox* box, const QString& name)
{
    box->insertItem(itemTitles[name], box->count());
}

void AppletConfig::setActive(const QStringList& list)
{
    availableBox->clear();
    activeBox->clear();

    QStringList::ConstIterator i;
    for (i = list.begin(); i != list.end(); ++i)
	insertItem(activeBox, *i);
    QMap<QString,QString>::Iterator it;
    for (it = itemTitles.begin(); it != itemTitles.end(); ++it)
	if (!list.contains(it.key()))
	    insertItem(availableBox, it.key());
    availableBox->sort();
}

QStringList AppletConfig::active()
{
    QStringList list;
    uint i;
    for (i=0; i < activeBox->count(); i++)
	list.append(itemNames[activeBox->text(i)]);
    return list;
}

void AppletConfig::moveRight()
{
    if (activeBox->count() >= 2) return;
    QListBoxItem* it = availableBox->selectedItem();
    if (!it) return;
    availableBox->setSelected(it, false);
    availableBox->takeItem(it);
    activeBox->insertItem(it, activeBox->selectedItem());
    activeBox->setSelected(it, true);
}

QFont AppletConfig::appletFont()
{
    return fontpreview->font();
}

void AppletConfig::setAppletFont(QFont f)
{
    fontpreview->setFont(f);
    fontpreview->setText(f.family() + " " + QString::number(f.pointSize()));
}

void AppletConfig::selectAppletFont()
{
    QFont f = fontpreview->font();
    if (KFontDialog::getFont(f, false, this) == KFontDialog::Accepted)
        setAppletFont(f);
}

void AppletConfig::moveLeft()
{
    if (activeBox->count() < 1) return;
    QListBoxItem* it = activeBox->selectedItem();
    if (!it) return;
    activeBox->setSelected(it, false);
    activeBox->takeItem(it);
    availableBox->insertItem(it);
    availableBox->setSelected(it, true);
    availableBox->sort();
}

void AppletConfig::moveUp()
{
    QListBoxItem* it = activeBox->selectedItem();
    if (!it) return;
    QListBoxItem* prev = it->prev();
    if (!prev) return;
    activeBox->setSelected(it, false);
    activeBox->takeItem(prev);
    activeBox->insertItem(prev, it);
    activeBox->setSelected(it, true);
}

void AppletConfig::moveDown()
{
    QListBoxItem* it = activeBox->selectedItem();
    if (!it) return;
    QListBoxItem* next = it->next();
    if (!next) return;
    activeBox->setSelected(it, false);
    activeBox->takeItem(it);
    activeBox->insertItem(it, next);
    activeBox->setSelected(it, true);
}
