/* -*- c++ -*-
 *
 * kcmdonkey.h
 *
 * Copyright (C) 2002-2004 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kcmdonkey_kcmdonkey_h__
#define __kcmdonkey_kcmdonkey_h__

#include "donkeyentry.h"
#include "donkeyconfig.h"

#include <kcmodule.h>

class KAboutData;
class DonkeyConfig;

class KCMDonkey : public KCModule
{
    Q_OBJECT

public:
    KCMDonkey( QWidget *parent=0, const char *name=0 );
    ~KCMDonkey();

    virtual void load();
    virtual void save();
    virtual void defaults();
    virtual int buttons();
    virtual QString quickHelp() const;
    virtual const KAboutData *aboutData() const;
    
private:
    DonkeyConfig* m_config;
};

#endif
