/* -*- c++ -*-
 *
 * downloadpage.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_downloadpage_h__
#define __kmldonkey_downloadpage_h__

#include <qobject.h>
#include <qvbox.h>
#include <qintdict.h>

#include "clipboard.h"
#include "page.h"

class QSplitter;
class KActionCollection;

class InfoList;

class DownloadPage : public QVBox, public KMLDonkeyPage, public ClipboardHelper
{
    Q_OBJECT
public:
    DownloadPage(QWidget* parent = 0);

    virtual void setupActions(KActionCollection*);
    virtual QStringList supportedGenericActions();
    virtual void handleGenericAction(const QString&);
    virtual void plugGenericActions(QObject*, const char*);
    virtual void deactivatePageActions();

    virtual void configurePrefsDialog(KMLDonkeyPreferences* prefs = 0);
    virtual void applyPreferences(KMLDonkeyPreferences* prefs = 0);
    virtual void saveState(KConfig* conf);
    virtual void restoreState(KConfig* conf);

    virtual void clear();

    InfoList* downloadView;
    InfoList* downloadedView;

    KToggleAction* hidePausedAction;

signals:
    void genericActionsChanged(KMLDonkeyPage*);

public slots:
    void fileUpdated(int fn);
    void fileRemoved(int fn);

    // Download actions
    void actionPauseFile();
    void actionResumeFile();
    void actionCancelFile();
    void actionFilePriorityVeryLow();
    void actionFilePriorityLow();
    void actionFilePriorityNormal();
    void actionFilePriorityHigh();
    void actionFilePriorityVeryHigh();
    void actionRenameFile();
    void actionRenameFileInPlace();
    void renameFile(int fileno, const QString& name);
    void actionRetryConnect();
    void actionPreviewFile();
    void actionVerifyFile();
    void actionGetFileFormat();
    void actionFileInformation();
    void actionCompleteFileInformation();
    void actionHidePaused(bool);

    // Complete actions
    void actionCommitFile();
    void actionCommitFileAs();
    void commitFileAs(int fileno, const QString& name);

    void actionActivatePage();

protected slots:
    void contextDownload(KListView*, QListViewItem*, const QPoint&);
    void contextDownloaded(KListView*, QListViewItem*, const QPoint&);
    void downloadDoubleClick(QListViewItem*);
    void clearDownloadSelection();
    void clearDownloadedSelection();

protected:
    void copyFileToClipboard(ClipFormat format);
    void copyCompleteToClipboard(ClipFormat format);
    void setFilePriority(int);


private:
    QSplitter* downloadSplitter;

    QIntDict<DownloadFile> downloadFileList;
    QIntDict<DownloadedFile> downloadedFileList;

    QPtrList<KAction> downloadActions;
    QPtrList<KAction> downloadedActions;

    void autorenameFile(int filenum, const QString& filename);
};

#endif
