/* -*- c++ -*-
 *
 * statspagerates.h
 *
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __kmldonkey_statspagerates_h__
#define __kmldonkey_statspagerates_h__

#include <qframe.h>
#include <qvbox.h>

#include "statspage.h"

class StatsWidgetObject
{
public:
    StatsWidgetObject() {}

    QValueList<long> values;
    bool enable;
    QColor color;
};

class StatsWidget : public QFrame
{
public:
    StatsWidget(QWidget *parent, long defaultmaxvalue);
    ~StatsWidget();

    /* Clear the StatsWidget. Remove all statistic and there views. */
    void clear();

    /* On the StatWidget different statistics could be shown. Each of
     * them did have an unique id. With addStat a new statistic could
     * be added.
     * \param id The source-id the stat should have/use. You have to
     *           add new values to the source-id with addStatValue.
     * \param color The used color to display the stat.
     */
    void addStat(const QString &statid);
    /* Remove an added statistic and all it's views. */
    void removeStat(const QString &statid);
    /* Sets if the statistic is enabled or disabled. */
    void setStatEnable(const QString &statid, const bool on);
    /* Sets the used color for the statistic */
    void setStatColor(const QString &statid, const QColor& color);

    /* Add a new value to the with statid defined statistic. */
    void addStatValue(const QString &statid, long value);

protected:
    virtual void paintEvent(QPaintEvent*);

private:
    QMap<QString, StatsWidgetObject*> stats;
    long maxvalue, minvalue;
};

class StatsPageRates : public QVBox
{
public:
    StatsPageRates(QWidget* parent);
    StatsWidget *statswidget;
};

#endif
