/* -*- c++ -*-
 *
 * donkeyhost.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "donkeyhost.h"
//#include "donkeyhost.moc" // don't know why the hell I got compile errors there again?!

DonkeyHost::DonkeyHost(const QString& h_name, const QString& h_address, int h_port,
	       const QString& h_username, const QString& h_password,
	       HostInterface::HostType h_type,
               const KURL& temp, const KURL& incoming,
	       const KURL& h_binaryPath, const KURL& h_rootPath,
	       HostInterface::StartupMode h_startupMode)
    : HostInterface(h_name, h_address, h_port, h_type, h_binaryPath, h_rootPath, h_startupMode)
    , m_username(h_username)
    , m_password(h_password)
    , m_temp(temp)
    , m_incoming(incoming)
{
}

DonkeyHost::DonkeyHost(DonkeyHost& host)
    : HostInterface(host)
{
    m_username = host.username();
    m_password = host.password();
    m_temp = host.tempDirectory();
    m_incoming = host.incomingDirectory();
}

DonkeyHost::DonkeyHost()
    : HostInterface()
{
}

const QString& DonkeyHost::username() const { return m_username; }
const QString& DonkeyHost::password() const { return m_password; }
const KURL& DonkeyHost::tempDirectory() const { return m_temp; }
const KURL& DonkeyHost::incomingDirectory() const { return m_incoming; }
