/* -*- c++ -*-
 *
 * shareinfo.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __libkmldonkey_shareinfo_h__
#define __libkmldonkey_shareinfo_h__

#include <qstring.h>

#include "donkeytypes.h"

class DonkeyMessage;

//! Representation of a shared file.

class ShareInfo
{

    public:

    ShareInfo(DonkeyMessage* msg, int proto);
    ShareInfo(const ShareInfo&);
    ~ShareInfo();

    void updateShare(DonkeyMessage* msg, int proto);

    //! The numerical ID of the share.
    const int shareNo() const;
    //! The network the file is being shared on.
    const int shareNetwork() const;
    //! The file name of the share.
    const QString& shareName() const;
    //! The size of the shared file, in bytes.
    const int64 shareSize() const;
    //! The number of bytes uploaded to clients.
    const int64 shareUploaded() const;
    //! The number of requests received for this share.
    const int shareRequests() const;
    //! The MD4 hash of the shared file.
    const QByteArray& shareMD4() const;

private:

    int num, network;
    QString name;
    int64 size, uploaded;
    int requests;
    QByteArray md4;
};

#endif
