/* -*- c++ -*-
*
* main.cpp
*
* Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*
*/

#include "version.h"
#include "mmserver.h"
#include "main.h"

#include <kconfig.h>
#include <kdebug.h>

MobileMule::MobileMule( const QCString& name )
        : KDEDModule( name )
{
    kdDebug( 7020 ) << "MobileMule::MobileMule(\"" << name << "\")" << endl;
    mmserver = 0;
    cfg = new KConfig( "mobilemulerc", true, false );
    cfg->setGroup( "MobileMule" );
    setEnabled( cfg->readBoolEntry( "Autostart", false ) );
    kdDebug( 7020 ) << "MobileMule initialised." << endl;
}

MobileMule::~MobileMule()
{
    kdDebug( 7020 ) << "MobileMule::~MobileMule()" << endl;
    if ( mmserver )
        delete mmserver;
    kdDebug( 7020 ) << "MobileMule terminated." << endl;
}

void MobileMule::setEnabled( bool state )
{
    kdDebug(7020) << "MobileMule::setEnabled(" << state << ")" << endl;
    if ( state && !mmserver ) {
        kdDebug( 7020 ) << "MobileMule: Starting server." << endl;
        int port = cfg->readNumEntry( "Port", 4081 );
        QString password = cfg->readEntry( "Password", "" );
        mmserver = new MMServer( "0.0.0.0", port, QString::null, password );
    } else if ( !state && mmserver ) {
        kdDebug( 7020 ) << "MobileMule: Stopping server." << endl;
        delete mmserver;
        mmserver = 0;
    }
}

void MobileMule::enable()
{
    setEnabled( true );
}

void MobileMule::disable()
{
    setEnabled( false );
}

bool MobileMule::enabled() const
{
    return ( bool ) mmserver;
}

extern "C"
{
    KDEDModule *create_mobilemule( const QCString & name ) {
        return new MobileMule( name );
    }
}

#include "main.moc"
