/* -*- c++ -*-
 *
 * options.h
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __libkmldonkey_options_h__
#define __libkmldonkey_options_h__

#include <qstring.h>

class DonkeyMessage;

//! Representation of a file.

class DonkeyOption
{

public:

    DonkeyOption(DonkeyMessage* msg, int proto);
    DonkeyOption(const DonkeyOption&);
    DonkeyOption() { advanced = false; }
    ~DonkeyOption();

    //! The section the option should appear in.
    const QString& optionSection() const;
    //! The option label.
    const QString& optionLabel() const;
    //! The option name.
    const QString& optionName() const;
    //! The option type.
    /*!
     * Possible type values:
     *
     * \li \c "String" a text string
     * \li \c "Int" an integer value
     * \li \c "Integer" alternative form of \c "Int" that appears occasionally
     * \li \c "Float" a floating point value
     * \li \c "Bool" a boolean value, either \c "true" or \c "false"
     * \li \c "Ip" an IP address
     * \li \c "Ip List" a list of IP addresses separated by spaces
     * \li \c "Addr" an IP address and port number, separated by a colon
     * \li \c "Md4" an MD4 hash
     * \li \c "Sha1" an SHA1 hash
     *
     * With protocol versions below 17, you'll only ever see \c "String" and \c "Bool" types.
     */
    const QString& optionType() const;
    //! The option's help string. Only available if protocol > 16.
    const QString& optionHelp() const;
    //! The option's current value. Only available if protocol > 16.
    const QString& optionValue() const;
    //! The option's default value. Only available if protocol > 16.
    const QString& optionDefaultValue() const;
    //! The option's advanced flag. Only available if protocol > 16.
    bool optionAdvanced() const;

private:

    QString section, label, name, type, help, value, defaultValue;
    bool advanced;

};

#endif
