/* -*- c++ -*-
 *
 * searchinfo.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "searchinfo.h"
#include "donkeymessage.h"

SearchInfo::SearchInfo(int id)
{
    num = id;
    results.setAutoDelete(true);
}

int SearchInfo::searchNo() const { return num; }
const QIntDict<ResultInfo>& SearchInfo::searchResults() const { return results; }
void SearchInfo::addResult(ResultInfo* result) { results.replace(result->resultNo(), result); }

ResultInfo::ResultInfo(DonkeyMessage* msg)
{
    int i;

    num = msg->readInt32();
    net = msg->readInt32();

    QString s;
    for (i = msg->readInt16(); i; i--) {
        s = msg->readString();
        names.append(s);
        if (name.length() < s.length()) name = s;
    }

    md4 = QByteArray(16);
    for (i=0; i<16; i++) {
        md4[i] = msg->readInt8();
    }

    size = msg->readInt32();
    format = msg->readString();
    t = msg->readString();

    for (i = msg->readInt16(); i; i--) {
        msg->readTag(tags);
    }

    comment = msg->readString();
    already_done = msg->readInt8() > 0;
}

ResultInfo::ResultInfo(const ResultInfo& ri)
{
    num = ri.resultNo();
    name = ri.resultName();
    names = ri.resultNames();
    size = ri.resultSize();
    net = ri.resultNetwork();
    format = ri.resultFormat();
    tags = ri.resultTags();
    comment = ri.resultComment();
    md4 = ri.resultMD4();
    already_done = ri.resultAlreadyDone();
}

ResultInfo::~ResultInfo()
{
}

int ResultInfo::resultNo() const { return num; }
const QString& ResultInfo::resultName() const { return name; }
const QStringList& ResultInfo::resultNames() const { return names; }
int32 ResultInfo::resultSize() const { return size; }
int32 ResultInfo::resultNetwork() const { return net; }
const QString& ResultInfo::resultFormat() const { return format; }
const QMap<QString,QVariant>& ResultInfo::resultTags() const { return tags; }
const QString& ResultInfo::resultComment() const { return comment; }
const QByteArray& ResultInfo::resultMD4() const { return md4; }
bool ResultInfo::resultAlreadyDone() const { return already_done; }
