/* -*- c++ -*-
 *
 * disclaimer.cpp
 *
 * Copyright (C) 2004 Petter E. Stokke <gibreel@kmldonkey.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "disclaimer.h"

#include <klocale.h>
#include <kglobal.h>
#include <kconfig.h>
#include <ktextbrowser.h>
#include <qvbox.h>
#include <qcheckbox.h>

DisclaimerDialog::DisclaimerDialog( QWidget* parent )
        : KDialogBase( parent, "DisclaimerDialog", true, i18n( "Disclaimer" ), KDialogBase::Ok )
{
    QVBox * c = new QVBox( this );
    KTextBrowser* b = new KTextBrowser( c );
    b->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding ) );
    b->setText( i18n( P2P_DISCLAIMER_TEXT ) );
    m_again = new QCheckBox( i18n( "&Do not show this message again" ), c );
    m_again->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed ) );
    setMainWidget( c );
    resize( QSize( 500, 400 ).expandedTo( minimumSizeHint() ) );
}

int DisclaimerDialog::exec()
{
    KConfig * conf = KGlobal::config();
    conf->setGroup( "DisclaimerDialog" );
    if ( conf->readBoolEntry( "DoNotShow", false ) )
        return QDialog::Accepted;
    int rv = KDialogBase::exec();
    conf->writeEntry( "DoNotShow", m_again->isChecked() );
    return rv;
}

#include "disclaimer.moc"
