/* -*- c++ -*-
 *
 * $Id: mldonkeyapplet.h,v 1.11 2003/07/23 18:03:47 gibreel Exp $
 *
 * Copyright (C) 2002, 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: mldonkeyapplet.h,v $
 * Revision 1.11  2003/07/23 18:03:47  gibreel
 * Support for multiple host definitions using HostManager.
 *
 * Revision 1.10  2003/07/01 23:08:23  gibreel
 * The applet and GUI now accept drag and drop events containing URLs, which
 * are passed on to the core.
 *
 * Revision 1.9  2003/06/09 23:06:01  gibreel
 * Improved applet configurability, fixed a few layout issues, and finally
 * implemented the mute button.
 *
 * Revision 1.8  2003/06/09 18:10:23  gibreel
 * Configurable availability display colours. Extended the DCOP interface and
 * improved the interaction between the GUI and the applet. Added colour for
 * the download list's queued state. Cleanups, bugfixes all round.
 *
 * Revision 1.7  2003/05/01 16:59:08  gibreel
 * Removed the GUI functionality from the applet, and reimplemented the GUI
 * button as a launcher and hide button (over DCOP) for the standalone GUI.
 *
 * Revision 1.6  2003/03/17 11:44:14  gibreel
 * Discarded the .ui files for mldonkeyappletgui in favour of own code. Now
 * uses KIconLoader to load icons rather than embedding them. Also layouts
 * itself properly when resized, and includes a different layout for small
 * panel sizes.
 *
 * Revision 1.5  2003/03/10 14:52:02  gibreel
 * Support for GUI protocol 14. Specifically: Authentication with username, new
 * download file state "Queued", and support for the new message types in the
 * DonkeyProtocol class.
 *
 * Revision 1.4  2003/03/10 00:23:27  gibreel
 * Added copy to clipboard features to file context menus.
 *
 * Revision 1.3  2003/03/08 20:13:18  gibreel
 * Switched readString/writeString in DonkeyMessage from using pointers to
 * QStrings to using references, which leads to far less hassle, shorter code,
 * and less chance of memory leaks.
 *
 * Revision 1.2  2003/03/07 15:10:57  gibreel
 * Cosmetic tweaks.
 *
 * Revision 1.1.1.1  2003/03/07 11:50:11  gibreel
 * Initial import.
 *
 */

#ifndef __mldonkeyapplet_h__
#define __mldonkeyapplet_h__

#include <kpanelapplet.h>
#include <dcopclient.h>
#include <qstringlist.h>
#include <qdragobject.h>
#include "mldonkeyappletiface.h"
#include "mldonkeyappletgui.h"
#include "donkeyprotocol.h"
#include "hostmanager.h"


class AppletConfig;

class MLDonkeyApplet : public KPanelApplet, virtual public MLDonkeyAppletIface

{
    Q_OBJECT

public:
    MLDonkeyApplet( const QString& configFile, Type t = Stretch,
		    int actions = 0, QWidget *parent = 0,
		    const char *name = 0 );
    ~MLDonkeyApplet();

    int widthForHeight( int height ) const;
    int heightForWidth( int width ) const;
    void about();
    void preferences();

    bool isGUIRunning();
    bool isGUIVisible();

    bool showLabels, showDouble, showMute;
    QStringList activeDisplays;

protected:

    void dragEnterEvent(QDragEnterEvent* event);
    void dropEvent(QDropEvent* event);

public slots:
    void showGUI(bool);
    void muteDonkey(bool);
    void connectDonkey();
    void refreshDisplay();
    void updateLabels();
    void updateStatus(int64 ul, int64 dl, int64 sh, int nsh, int tul, int tdl, int uul, int udl, int ndl, int ncp);
    void donkeyDisconnected(int err);
    void donkeyConnected();

    void notifyUnhandled(int op);

    void applicationRemoved(const QCString& appId);

    virtual void kmldonkeyAppeared(bool);

protected:
    void resizeEvent(QResizeEvent*);
    void writeConfiguration();
    void restoreConfiguration();
    QString produceStatus(const QString& key, int64 ul, int64 dl, int64 sh, int nsh, int tul, int tdl, int uul, int udl, int ndl, int ncp);

protected slots:
    void applyConfig();

private:
    KAboutData* aboutData;
    MLDonkeyAppletGUI* gui;
    AppletConfig* configDialog;

    DCOPClient* client;

    QTimer* timer;

    DonkeyProtocol* donkey;
    HostManager* hostManager;

    QString donkeyHost, donkeyUname, donkeyPasswd;
    int donkeyPort;
    int reconnect;

    int muteUploadRate, muteDownloadRate;
    int normalUploadRate, normalDownloadRate;
};

#endif
