/*
 * $Id: mldonkeyappletgui.cpp,v 1.4 2003/06/09 23:06:01 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: mldonkeyappletgui.cpp,v $
 * Revision 1.4  2003/06/09 23:06:01  gibreel
 * Improved applet configurability, fixed a few layout issues, and finally
 * implemented the mute button.
 *
 * Revision 1.3  2003/05/15 12:20:44  gibreel
 * Applied patch #1482, closes #3587.
 *
 * Revision 1.2  2003/05/01 16:59:08  gibreel
 * Removed the GUI functionality from the applet, and reimplemented the GUI
 * button as a launcher and hide button (over DCOP) for the standalone GUI.
 *
 * Revision 1.1  2003/03/17 11:44:14  gibreel
 * Discarded the .ui files for mldonkeyappletgui in favour of own code. Now
 * uses KIconLoader to load icons rather than embedding them. Also layouts
 * itself properly when resized, and includes a different layout for small
 * panel sizes.
 *
 */


#include <klocale.h>
#include <qvariant.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <kpushbutton.h>
#include <kiconloader.h>
#include <kguiitem.h>

#include "mldonkeyappletgui.h"
#include "mldonkeyapplet.h"

/*
 *  Constructs a MLDonkeyAppletGUI as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 */
MLDonkeyAppletGUI::MLDonkeyAppletGUI( QWidget* parent, const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    if ( !name )
	setName( "MLDonkeyAppletGUI" );

    KIconLoader icons("mldonkeyapplet");

    QIconSet muteIcon(icons.loadIcon("mld-mutedonkey", KIcon::User));
    muteIcon.setPixmap(icons.loadIcon("mld-unmutedonkey", KIcon::User), QIconSet::Small, QIconSet::Normal, QIconSet::On);

    LaunchButton = new KPushButton( this, "LaunchButton" );
    LaunchButton->setSizePolicy( QSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed, 0, 0, LaunchButton->sizePolicy().hasHeightForWidth() ) );
    LaunchButton->setMaximumSize( QSize( 20, 20 ) );
    LaunchButton->setFocusPolicy( QPushButton::NoFocus );
    LaunchButton->setIconSet( icons.loadIconSet("mld-launchgui", KIcon::User) );
    LaunchButton->setToggleButton( TRUE );


    MuteButton = new KPushButton( this, "MuteButton" );
    MuteButton->setSizePolicy( QSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed, 0, 0, MuteButton->sizePolicy().hasHeightForWidth() ) );
    MuteButton->setMaximumSize( QSize( 20, 20 ) );
    MuteButton->setFocusPolicy( QPushButton::NoFocus );
    MuteButton->setIconSet(muteIcon);
    MuteButton->setToggleButton( TRUE );

    FirstLabel = new QLabel( this, "FirstLabel" );
    FirstLabel->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, FirstLabel->sizePolicy().hasHeightForWidth() ) );
    FirstLabel->setMaximumSize( QSize( 32767, 20 ) );
    FirstLabel->setMargin( 2 );
    FirstLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    SecondLabel = new QLabel( this, "SecondLabel" );
    SecondLabel->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, SecondLabel->sizePolicy().hasHeightForWidth() ) );
    SecondLabel->setMaximumSize( QSize( 32767, 20 ) );
    SecondLabel->setMargin( 2 );
    SecondLabel->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    SecondStatus = new QLabel( this, "SecondStatus" );
    SecondStatus->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, SecondStatus->sizePolicy().hasHeightForWidth() ) );
    SecondStatus->setMaximumSize( QSize( 32767, 20 ) );
    SecondStatus->setFrameShape( QLabel::Panel );
    SecondStatus->setFrameShadow( QLabel::Sunken );

    FirstStatus = new QLabel( this, "FirstStatus" );
    FirstStatus->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Fixed, 0, 0, FirstStatus->sizePolicy().hasHeightForWidth() ) );
    FirstStatus->setMaximumSize( QSize( 32767, 20 ) );
    FirstStatus->setFrameShape( QLabel::Panel );
    FirstStatus->setFrameShadow( QLabel::Sunken );

    SecondStatus->setText( "..." );
    FirstStatus->setText( "..." );

    connect(LaunchButton, SIGNAL(toggled(bool)), this, SLOT(toggleLaunch(bool)));
    connect(MuteButton, SIGNAL(toggled(bool)), this, SLOT(toggleMute(bool)));

    setSizePolicy( QSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed, 0, 0, sizePolicy().hasHeightForWidth() ) );

    mysize = -1;
    horiz = NULL; grid = NULL;
    relayoutWidgets(0);
}

/*
 *  Destroys the object and frees any allocated resources
 */
MLDonkeyAppletGUI::~MLDonkeyAppletGUI()
{
    // no need to delete child widgets, Qt does it all for us
}

void MLDonkeyAppletGUI::updateLayout()
{
    hide();

    if (horiz) delete horiz;
    if (grid) delete grid;
    horiz = NULL; grid = NULL;

    MLDonkeyApplet* app = (MLDonkeyApplet*)parent();

    if (!mysize) {
	MuteButton->show();
	if (app->showLabels) {
	    FirstLabel->show();
	    SecondLabel->show();
	    grid = new QGridLayout(this, 2, 3, 0, 0);
	    grid->addWidget( LaunchButton, 0, 2, Qt::AlignAuto );
	    grid->addWidget( MuteButton, 1, 2, Qt::AlignAuto );
	    grid->addWidget( SecondStatus, 1, 1, Qt::AlignAuto );
	    grid->addWidget( SecondLabel, 1, 0, Qt::AlignAuto );
	    grid->addWidget( FirstLabel, 0, 0, Qt::AlignAuto );
	    grid->addWidget( FirstStatus, 0, 1, Qt::AlignAuto );
	} else {
	    FirstLabel->hide();
	    SecondLabel->hide();
	    grid = new QGridLayout(this, 2, 2, 0, 0);
	    grid->addWidget( LaunchButton, 0, 1, Qt::AlignAuto );
	    grid->addWidget( MuteButton, 1, 1, Qt::AlignAuto );
	    grid->addWidget( SecondStatus, 1, 0, Qt::AlignAuto );
	    grid->addWidget( FirstStatus, 0, 0, Qt::AlignAuto );
	}
    } else {
	horiz = new QHBoxLayout(this);
	if (app->showLabels && !app->showDouble) {
	    FirstLabel->show();
	    horiz->addWidget(FirstLabel, Qt::AlignAuto);
	} else FirstLabel->hide();
	horiz->addWidget( FirstStatus, Qt::AlignAuto );

	if (app->showLabels && !app->showDouble) {
	    SecondLabel->show();
	    horiz->addWidget(SecondLabel, Qt::AlignAuto);
	} else SecondLabel->hide();
	horiz->addWidget( SecondStatus, Qt::AlignAuto );

	horiz->addWidget( LaunchButton, Qt::AlignAuto );
	if (app->showMute) {
	    MuteButton->show();
	    horiz->addWidget( MuteButton, Qt::AlignAuto );
	}
	else MuteButton->hide();
    }

    adjustSize();
    show();
}

void MLDonkeyAppletGUI::relayoutWidgets(int small)
{
    if (mysize == small) return;
    mysize = small;
    updateLayout();
}

void MLDonkeyAppletGUI::updateLabels(const QString first, const QString second)
{
    FirstLabel->setText(first);
    SecondLabel->setText(second);
}

void MLDonkeyAppletGUI::updateStatus(const QString first, const QString second)
{
    FirstStatus->setText(first);
    SecondStatus->setText(second);
}

void MLDonkeyAppletGUI::donkeyDisconnected()
{
    SecondStatus->setText("...");
    FirstStatus->setText("...");
}

void MLDonkeyAppletGUI::setLaunchState(bool state)
{
    LaunchButton->setOn(state);
}

void MLDonkeyAppletGUI::toggleLaunch(bool t)
{
    emit toggledLaunch(t);
}

void MLDonkeyAppletGUI::toggleMute(bool t)
{
    emit toggledMute(t);
}

#include "mldonkeyappletgui.moc"
