/*
 * $Id: mldonkeyappletgui.h,v 1.3 2003/06/09 23:06:01 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: mldonkeyappletgui.h,v $
 * Revision 1.3  2003/06/09 23:06:01  gibreel
 * Improved applet configurability, fixed a few layout issues, and finally
 * implemented the mute button.
 *
 * Revision 1.2  2003/05/01 16:59:09  gibreel
 * Removed the GUI functionality from the applet, and reimplemented the GUI
 * button as a launcher and hide button (over DCOP) for the standalone GUI.
 *
 * Revision 1.1  2003/03/17 11:44:14  gibreel
 * Discarded the .ui files for mldonkeyappletgui in favour of own code. Now
 * uses KIconLoader to load icons rather than embedding them. Also layouts
 * itself properly when resized, and includes a different layout for small
 * panel sizes.
 *
 */

#ifndef MLDONKEYAPPLETGUI_H
#define MLDONKEYAPPLETGUI_H

#include <qwidget.h>
#include <qmap.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QLabel;
class QPushButton;

class MLDonkeyAppletGUI : public QWidget
{
    Q_OBJECT

public:
    MLDonkeyAppletGUI( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~MLDonkeyAppletGUI();

    void relayoutWidgets(int small);

    QWidget* widgetContainer;
    QPushButton* LaunchButton;
    QPushButton* MuteButton;
    QLabel* FirstLabel;
    QLabel* SecondLabel;
    QLabel* SecondStatus;
    QLabel* FirstStatus;

public slots:
    virtual void updateLayout();
    void updateLabels(const QString, const QString);
    void updateStatus(const QString, const QString);
    virtual void donkeyDisconnected();
    virtual void setLaunchState(bool state);

signals:
    void toggledLaunch(bool t);
    void toggledMute(bool t);

protected:

    QHBoxLayout* lay;
    QHBoxLayout* horiz;
    QGridLayout* grid;
    int mysize;

protected slots:
    virtual void toggleLaunch(bool t);
    virtual void toggleMute(bool t);
};

#endif // MLDONKEYAPPLETGUI_H
