/* -*- c++ -*-
 *
 * $Id: kcmdonkey.h,v 1.5 2003/07/23 18:03:22 gibreel Exp $
 *
 * Copyright (C) 2002 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: kcmdonkey.h,v $
 * Revision 1.5  2003/07/23 18:03:22  gibreel
 * KCMDonkey now allows for multiple host definitions.
 *
 * Revision 1.4  2003/07/17 15:39:12  gibreel
 * Release preparation.
 *
 * Revision 1.3  2003/05/28 19:50:02  gibreel
 * Added facilities for launching the (as yet unwritten) MLDonkey config tool
 * from the GUI and control centre applet.
 *
 * Revision 1.2  2003/03/10 14:52:02  gibreel
 * Support for GUI protocol 14. Specifically: Authentication with username, new
 * download file state "Queued", and support for the new message types in the
 * DonkeyProtocol class.
 *
 * Revision 1.1.1.1  2003/03/07 11:50:16  gibreel
 * Initial import.
 *
 */

#ifndef _KCMDONKEY_H_
#define _KCMDONKEY_H_

#include <qvariant.h>
#include <qwidget.h>
#include <qlistbox.h>
#include <kcmodule.h>

class KCMDonkeyUI;
class KAboutData;

class DonkeyEntry : public QListBoxText
{
public:
    DonkeyEntry(QListBox* box, const QString& name, const QString& address,
		int telnetPort, int guiPort, const QString& username, const QString& password,
		bool isDefault = false);

    const QString& getName() { return m_name; }
    const QString& getAddress() { return m_address; }
    int getTelnetPort() { return m_telnetPort; }
    int getGuiPort() { return m_guiPort; }
    const QString& getUsername() { return m_username; }
    const QString& getPassword() { return m_password; }
    bool getDefault() { return m_default; }

    void setName(const QString& name);
    void setAddress(const QString& address) { m_address = address; }
    void setTelnetPort(int port) { m_telnetPort = port; }
    void setGuiPort(int port) { m_guiPort = port; }
    void setUsername(const QString& username) { m_username = username; }
    void setPassword(const QString& password) { m_password = password; }
    void setDefault(bool isDefault);

private:
    QString m_name, m_address, m_username, m_password;
    int m_telnetPort, m_guiPort;
    bool m_default;
};

class KCMDonkey : public KCModule
{
    Q_OBJECT

public:
    KCMDonkey( QWidget *parent=0, const char *name=0 );
    ~KCMDonkey();

    virtual void load();
    virtual void save();
    virtual void defaults();
    virtual int buttons();
    virtual QString quickHelp() const;
    virtual const KAboutData *aboutData() const;
    
public slots:
    void configChanged();

protected slots:
    void entrySelected(QListBoxItem*);
    void nameChanged(const QString&);
    void addressChanged(const QString&);
    void usernameChanged(const QString&);
    void passwordChanged(const QString&);
    void telnetPortChanged(int);
    void guiPortChanged(int);
    void defaultButtonClicked();
    void newButtonClicked();
    void deleteButtonClicked();

private:
    void setDefaultEntry(DonkeyEntry* entry);
    DonkeyEntry* getActiveEntry();

    KCMDonkeyUI* ui;
    KConfig* m_pConfig;

    KListBox* hostList;
    QLabel* telnetPortLabel;
    KLineEdit* nameEntry;
    QLabel* addressLabel;
    QLabel* guiPortLabel;
    KLineEdit* addressEntry;
    KIntNumInput* telnetPortEntry;
    KIntNumInput* guiPortEntry;
    KLineEdit* usernameEntry;
    QLabel* passwordLabel;
    QLabel* nameLabel;
    KPasswordEdit* passwordEntry;
    QLabel* usernameLabel;
    KPushButton* defaultButton;
    KPushButton* newButton;
    KPushButton* deleteButton;

    DonkeyEntry* defaultEntry;
    DonkeyEntry* activeEntry;

    bool processSignals;
};

#endif
