/*
 * $Id: colorselector.cpp
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: colorselector.cpp,v $
 * Revision 1.1  2003/05/30 11:53:00  dipesh
 * Optional colored Downloadlist
 *
 *
 */

#include "colorselector.h"

#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>
#include <kcolordialog.h>

ColorSelector::ColorSelector(QWidget *parent, const QString caption, const char *name)
    : QHBox(parent, name)
{
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Minimum);

    new QLabel(caption,this);
    preview = new KSqueezedTextLabel(this);
    preview->setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
    preview->setSizePolicy(QSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed,
                                       0, 0, preview->sizePolicy().hasHeightForWidth()));

    chooseButton = new KPushButton(i18n("Choose..."), this);
    chooseButton->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Fixed);

    connect(chooseButton, SIGNAL(clicked()), this, SLOT(selectColor()));
}

QColor& ColorSelector::getColor()
{
    return color;
}

void ColorSelector::setColor(QColor& col)
{
    color = col;
    preview->setPaletteForegroundColor(color);
    preview->setText(color.name());
    setMinimumSize(sizeHint());
}

void ColorSelector::selectColor()
{
    QColor col = color;
    if (KColorDialog::getColor(col) == KColorDialog::Accepted) setColor(col);
}

#include "colorselector.moc"
