/* -*- c++ -*-
 *
 * $Id: consolepage.cpp,v 1.10 2003/07/30 14:22:51 dipesh Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: consolepage.cpp,v $
 * Revision 1.10  2003/07/30 14:22:51  dipesh
 * looks nicer :)
 *
 * Revision 1.9  2003/07/27 20:24:26  gibreel
 * Added KActions for switching between pages.
 *
 * Revision 1.8  2003/07/19 17:18:37  dipesh
 * and one more time the Url-grabbing, now it's rfc 2396 conform :-)
 *
 * Revision 1.7  2003/07/19 13:13:42  gibreel
 * Extended URL regexp, and added code to keep from inserting multiple hr's
 * when trying to stay connected to a core that's gone away.
 *
 * Revision 1.6  2003/07/18 15:53:30  gibreel
 * Some style tweaks for the console page.
 *
 * Revision 1.5  2003/07/18 09:32:58  dipesh
 * ups, forgot to remove my testcase :)
 *
 * Revision 1.3  2003/07/15 18:15:59  dipesh
 * Present urls as clickable links
 *
 * Revision 1.2  2003/06/30 14:59:22  gibreel
 * Updated lists to support libkmldonkey's new removed signals. Moved pages'
 * connect statements out of KMLDonkey's constructor into their own
 * constructors. Added a debug console displaying dumps of unhandled messages.
 *
 * Revision 1.1  2003/06/19 21:50:45  gibreel
 * Split the various pages off into individual objects, and made a ton of code
 * cleanups, API changes, and not a few bugfixes in the process. The
 * disconnect/reconnect bug, especially, now seems to be gone.
 *
 */

#include <qregexp.h>

#include <klocale.h>
#include <ktextbrowser.h>
#include <klineedit.h>
#include <kaction.h>

#include "kmldonkey.h"
#include "consolepage.h"
#include "consolepage.moc"

ConsolePage::ConsolePage(QWidget* parent)
    : QVBox(parent, "consolePage")
    , KMLDonkeyPage()
{
    alreadyClear = true;

    consoleView = new KTextBrowser(this, "consoleView");
    consoleView->setFocusPolicy(QTextBrowser::ClickFocus);
    consoleView->setTextFormat(QTextBrowser::RichText);
    consoleView->setLinkUnderline(true);

    consoleView->append(QString("<b>KMLDonkey ") + VERSION + "</b>, Copyright  2003 Petter E. Stokke");
    consoleView->append(QString("<p>This program is free software; you can redistribute it and/or modify "
                                "it under the terms of the GNU General Public License as published by "
                                "the Free Software Foundation; either version 2 of the License, or "
                                "(at your option) any later version.</p>"
                                "<p>This program is distributed in the hope that it will be useful, "
                                "but WITHOUT ANY WARRANTY; without even the implied warranty of "
                                "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
                                "GNU General Public License for more details.</p>"
                                "<p>You should have received a copy of the GNU General Public License "
                                "along with this program; if not, write to the Free Software "
                                "Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA</p><hr>"));

    consoleEntry = new KLineEdit(this, "consoleEntry");
    connect(consoleEntry, SIGNAL(returnPressed(const QString&)),
	    consoleEntry->completionObject(), SLOT(addItem(const QString&)));
    connect(consoleEntry, SIGNAL(returnPressed(const QString&)),
            this, SLOT(sendConsoleMessage(const QString&)));

    connect(KMLDonkey::App->donkey, SIGNAL(consoleMessage(const QString&)), this, SLOT(consoleMessage(const QString&)));
}

void ConsolePage::clear()
{
    if (!alreadyClear) {
	consoleView->append("<hr>");
	alreadyClear = true;
    }
}

void ConsolePage::applyPreferences(KMLDonkeyPreferences*)
{
    consoleView->setFont(KMLDonkey::App->consoleFont);
}

void ConsolePage::setupActions(KActionCollection* actionCollection)
{
    (void)new KAction(i18n("Activate console page"), 0, 0, this, SLOT(actionActivatePage()),
		      actionCollection, "activate_page_console");
}

void ConsolePage::consoleMessage(const QString& msg)
{
    alreadyClear = false;

    QString txt = msg;
    txt.replace("&", "&amp;");
    txt.replace("<", "&lt;");
    txt.replace(">", "&gt;");

    QRegExp rxurl("[^\">]((http|ftp|news)://[\\w\\.\\-\\_/~?=&%;:@+$,!*'\\(\\)\\|\\^\\[\\]\\`\\{\\}]+)");
    int pos = 0;
    QString url;
    while ((pos = rxurl.search(txt, pos)) >= 0) {
        url = rxurl.cap(1);
        txt.replace(pos + 1, url.length(), "<a href=\"" + url + "\">" + url + "</a>");
    }

    if (txt.startsWith("\n+--"))
        txt = "<b>" + txt + "</b>";
    else if (txt.startsWith("CORRUPTION DETECTED"))
        txt = "<p><b>" + txt + "</b></p>";

    txt.replace(QRegExp("\n(?!$)"), "<br>");

    consoleView->append(txt);
}

void ConsolePage::sendConsoleMessage(const QString& txt)
{
    alreadyClear = false;

    QString foo = "<p><b>" + txt + "</b></p>";
    consoleView->append(foo);
    consoleEntry->clear();
    foo = txt;
    KMLDonkey::App->donkey->sendConsoleMessage(foo);
}

void ConsolePage::actionActivatePage()
{
    KMLDonkey::App->activatePage(this);
}

