/* -*- c++ -*-
 *
 * $Id: debugpage.h,v 1.1 2003/06/30 14:59:22 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: debugpage.h,v $
 * Revision 1.1  2003/06/30 14:59:22  gibreel
 * Updated lists to support libkmldonkey's new removed signals. Moved pages'
 * connect statements out of KMLDonkey's constructor into their own
 * constructors. Added a debug console displaying dumps of unhandled messages.
 *
 * Revision 1.1  2003/06/19 21:50:45  gibreel
 * Split the various pages off into individual objects, and made a ton of code
 * cleanups, API changes, and not a few bugfixes in the process. The
 * disconnect/reconnect bug, especially, now seems to be gone.
 *
 */

#ifndef __kmldonkey_debugpage_h__
#define __kmldonkey_debugpage_h__

#include <qobject.h>
#include <qvbox.h>

#include "page.h"

class KMLDonkeyPreferences;
class KTextBrowser;

class DebugPage : public QVBox, public KMLDonkeyPage
{
    Q_OBJECT
public:
    DebugPage(QWidget* parent = 0);

    virtual void applyPreferences(KMLDonkeyPreferences* = 0);
    virtual void clear();

public slots:
    void write(const DonkeyMessage* msg);
    void write(const QString& msg);

private:
    KTextBrowser* debugView;
};

#endif
