/*
 * $Id: fontselector.h,v 1.1 2003/03/23 23:40:01 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: fontselector.h,v $
 * Revision 1.1  2003/03/23 23:40:01  gibreel
 * Preliminary version of standalone GUI.
 *
 */

#ifndef __kmldonkey_fontselector_h__
#define __kmldonkey_fontselector_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qfont.h>
#include <qhbox.h>
#include <ksqueezedtextlabel.h>
#include <kpushbutton.h>

class FontSelector : public QHBox
{
    Q_OBJECT
public:
    FontSelector(QWidget* parent = NULL, const char* name = NULL, bool fixed = false);

    QFont& font();
    void setFont(QFont& font);

signals:
    void fontSelected(QFont&);

protected slots:
    void selectFont();

private:
    QFont ft;
    KSqueezedTextLabel* preview;
    KPushButton* chooseButton;
    bool wantFixed;
};

#endif // __kmldonkey_fontselector_h__
