/* -*- c++ -*-
 *
 * $Id: friendpage.h,v 1.6 2003/07/27 20:24:26 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: friendpage.h,v $
 * Revision 1.6  2003/07/27 20:24:26  gibreel
 * Added KActions for switching between pages.
 *
 * Revision 1.5  2003/07/19 20:20:32  gibreel
 * Uses autoconf to detect the presence of KTabWidget, rather than guessing its
 * presence using KDE_IS_VERSION.
 *
 * Revision 1.4  2003/07/19 14:18:22  gibreel
 * Uses KTabWidget instead of QTabWidget/ClosableTabWidget if available (KDE
 * 3.2 or CVS). ClosableTabWidget API changed to match KTabWidget's.
 *
 * Revision 1.3  2003/07/17 20:39:50  gibreel
 * Added actions to the friend file lists, so they're actually good for
 * something besides spying for the RIAA.
 *
 * Revision 1.2  2003/07/17 19:55:07  gibreel
 * Implemented multiple friend file view tabs.
 *
 * Revision 1.1  2003/06/30 23:30:35  gibreel
 * Preliminary friend list support. A ton of updates to the libkmldonkey API to
 * accommodate this, most notably improvements to the search handling
 * necessitated by mldonkey's somewhat awkward reporting of friend shares.
 *
 */

#ifndef __kmldonkey_friendpage_h__
#define __kmldonkey_friendpage_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qobject.h>
#include <qvbox.h>
#include <qdict.h>
#include <qintdict.h>

#include <searchinfo.h>

#include "clipboard.h"
#include "page.h"

class KActionCollection;

class KMLDonkeyPreferences;
class InfoList;
class ClientFile;

#ifdef HAS_KTABWODGET
class KTabWidget;
#else
class ClosableTabWidget;
#endif

class FriendShares
{
public:
    QMap<QString,QValueList<int> > dirs;
};

class FriendPage : public QVBox, public KMLDonkeyPage, public ClipboardHelper
{
    Q_OBJECT
public:
    FriendPage(QWidget* parent = 0);

    virtual void setupActions(KActionCollection*);

    virtual void applyPreferences(KMLDonkeyPreferences* prefs = 0);
    virtual void saveState(KConfig* conf);
    virtual void restoreState(KConfig* conf);

    virtual void clear();

public slots:
    void friendUpdated(int client);
    void friendRemoved(int client);

protected slots:
    void closeAllFileLists();
    void openFileList(int client);
    void closeFileList(QWidget*);

    void openFriendFiles(QListViewItem* item);

    void contextFriend(KListView*,QListViewItem*,const QPoint&);
    void contextFile(KListView*,QListViewItem*,const QPoint&);

    void actionAddFriend();
    void actionRemoveFriend();
    void actionConnectFriend();

    void actionDownload();
    void actionForceDownload();
    void actionDownloadAs();
    void actionCopyURL();
    void actionCopyHTML();
    void actionCopyHash();

    void actionActivatePage();

    void receiveShare(int clno, const QString& dir, int result);

    void mightUpdateShareList();

protected:

private:
    void constructFileList(int clno);
    QPtrList<QListViewItem> currentFileListSelection();
    void downloadSelected(bool force, bool ask);
    void copyFileToClipboard(ClipFormat format);

    QSplitter *friendVSplitter, *friendHSplitter;
    InfoList *friendView;
#ifdef HAVE_KTABWIDGET
    KTabWidget* fileTab;
#else
    ClosableTabWidget *fileTab;
#endif

    QIntDict<InfoList> fileViews;

    QIntDict<ClientItem> friendList;
    QIntDict<FriendShares> shares;

    QMap<int,bool> pleaseUpdateShareList;
};

#endif
