/* -*- c++ -*-
 *
 * $Id: kmldonkey.h,v 1.35 2003/07/27 20:24:26 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: kmldonkey.h,v $
 * Revision 1.35  2003/07/27 20:24:26  gibreel
 * Added KActions for switching between pages.
 *
 * Revision 1.34  2003/07/23 18:04:39  gibreel
 * Support for multiple host definitions using HostManager. Configurable
 * charset encoding.
 *
 * Revision 1.33  2003/07/19 20:20:32  gibreel
 * Uses autoconf to detect the presence of KTabWidget, rather than guessing its
 * presence using KDE_IS_VERSION.
 *
 * Revision 1.32  2003/07/19 14:18:22  gibreel
 * Uses KTabWidget instead of QTabWidget/ClosableTabWidget if available (KDE
 * 3.2 or CVS). ClosableTabWidget API changed to match KTabWidget's.
 *
 * Revision 1.31  2003/06/30 23:30:35  gibreel
 * Preliminary friend list support. A ton of updates to the libkmldonkey API to
 * accommodate this, most notably improvements to the search handling
 * necessitated by mldonkey's somewhat awkward reporting of friend shares.
 *
 * Revision 1.30  2003/06/30 14:59:22  gibreel
 * Updated lists to support libkmldonkey's new removed signals. Moved pages'
 * connect statements out of KMLDonkey's constructor into their own
 * constructors. Added a debug console displaying dumps of unhandled messages.
 *
 * Revision 1.29  2003/06/29 15:04:59  gibreel
 * Fixed the Vanishing KMLDonkey bug.
 *
 * Revision 1.28  2003/06/28 21:55:13  gibreel
 * Configurable coloured source list.
 *
 * Revision 1.27  2003/06/19 21:50:45  gibreel
 * Split the various pages off into individual objects, and made a ton of code
 * cleanups, API changes, and not a few bugfixes in the process. The
 * disconnect/reconnect bug, especially, now seems to be gone.
 *
 * Revision 1.26  2003/06/19 17:04:32  gibreel
 * Minor code cleanups and attempt to fix the crash bugs on
 * disconnect/reconnect. Both kmldonkey and libkmldonkey now clean out their
 * state data when the connection with the core is lost.
 *
 * Revision 1.25  2003/06/16 13:18:16  dipesh
 * Added KAction's for "Connect more servers", "Add server" and "Remove old servers"
 *
 * Revision 1.24  2003/06/14 15:29:17  dipesh
 * Fixed bad performance with a large serverlist.
 *
 * Revision 1.23  2003/06/13 18:20:01  gibreel
 * Libkmldonkey now uses references instead of pointers everywhere except where
 * it would cause an obvious performance impact, which should lead to less
 * chance of memory leaks and cleaner code in general. Almost everything that
 * should be const is now also const.
 *
 * Revision 1.22  2003/06/13 09:50:53  dipesh
 * optional coloured server- and search lists
 *
 * Revision 1.21  2003/06/09 18:10:23  gibreel
 * Configurable availability display colours. Extended the DCOP interface and
 * improved the interaction between the GUI and the applet. Added colour for
 * the download list's queued state. Cleanups, bugfixes all round.
 *
 * Revision 1.20  2003/05/30 11:53:00  dipesh
 * Optional colored Downloadlist
 *
 * Revision 1.19  2003/05/29 23:47:55  gibreel
 * Added shared file list refresh action. For some reason, though, the core
 * seems to only want to respond to the refresh request once...
 *
 * Revision 1.18  2003/05/28 19:50:02  gibreel
 * Added facilities for launching the (as yet unwritten) MLDonkey config tool
 * from the GUI and control centre applet.
 *
 * Revision 1.17  2003/05/26 15:49:46  gibreel
 * Improved connect/disconnect code: added KActions for connecting to and
 * disconnecting from the mldonkey core, and an option for trying to stay
 * connected at all times (behaving essentially like the applet does).
 *
 * Revision 1.16  2003/05/26 14:31:46  dipesh
 * Added prefs; Statusbar-label's + save on exit
 *
 * Revision 1.15  2003/05/24 11:24:48  dipesh
 * Added some more Output to the statusBar()
 *
 * Revision 1.14  2003/05/18 17:58:22  dipesh
 * Added KAction's Download, ForceDownload and RemoveServers
 *
 * Revision 1.13  2003/05/12 16:03:23  gibreel
 * Switched the main KTabCtl over to a QTabWidget and added icons to the page
 * titles. How odd that KDE's "extended" tab widget doesn't support icon labels
 * when Qt's original one does.
 *
 * Revision 1.12  2003/05/11 08:34:09  dipesh
 * Adding initial Search-functionality
 *
 * Revision 1.11  2003/05/03 13:51:56  dipesh
 * Added "Show Toolbar" and "Show Statusbar" to the the Prefs and create KMLDonkeyPreferences-instance only if needed and not already at startup.
 *
 * Revision 1.9  2003/04/27 23:00:10  gibreel
 * Double clicking on an item in the download list opens the file info dialog.
 *
 * Revision 1.8  2003/04/27 16:10:08  gibreel
 * Applied another patch from dipesh <dipesh@gmx.de> which adds the Show All
 * Servers action to the prefs dialog, and cleans up prefs handling a little.
 * The prefs dialog now also remembers its size.
 *
 * Revision 1.7  2003/04/26 18:27:45  gibreel
 * Applied a patch from dipesh <dipesh@gmx.de> for hiding non-connected
 * servers from the server list.
 *
 * Revision 1.6  2003/04/15 15:07:30  gibreel
 * Added server copy-to-clipboard actions too.
 *
 * Revision 1.5  2003/04/15 14:54:56  gibreel
 * Added copy-to-clipboard actions.
 *
 * Revision 1.4  2003/04/06 21:29:45  gibreel
 * Rudimentary server actions, and all lists now display network type.
 *
 * Revision 1.3  2003/04/06 19:22:52  gibreel
 * Added the remaining actions for the download list (but still missing the
 * file information dialog).
 *
 * Revision 1.2  2003/03/24 15:36:52  gibreel
 * More work; still not complete, but getting there.
 *
 * Revision 1.1  2003/03/23 23:40:01  gibreel
 * Preliminary version of standalone GUI.
 *
 */

#ifndef __kmldonkey_kmldonkey_h__
#define __kmldonkey_kmldonkey_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>
#include <ktextbrowser.h>
#include <klineedit.h>
#include <dcopclient.h>
#include <qtimer.h>
#include <qptrlist.h>

#include "kmldonkeyiface.h"
#include "infolist.h"
#include "page.h"

#ifdef HAVE_KTABWIDGET
class KTabWidget;
#else
class QTabWidget;
#endif

class QVBox;
class QSplitter;
class QLabel;
class QSignalMapper;
class KToggleAction;
class KActionMenu;

class DonkeyProtocol;
class HostManager;

class KMLDonkeyPreferences;
class ServerPage;
class SearchPage;
class DownloadPage;
class SharePage;
class FriendPage;
class ConsolePage;
class DebugPage;

class KMLDonkey : public KMainWindow, virtual public KMLDonkeyIface
{
    Q_OBJECT
public:
    KMLDonkey();

    static KMLDonkey *App;
    DonkeyProtocol* donkey;
    HostManager* hostManager;

    // Configuration variables
    bool colorServerView;
    QColor colorServerNotConnected, colorServerBlacklisted, colorServerConnecting, colorServerConnected;
    bool colorSearchView;
    QColor colorSearchFewSources, colorSearchManySources, colorSearchAlreadyDone;
    int searchThreshold;
    bool colorDownloadView;
    QColor colorDownloadDownloading, colorDownloadPaused, colorDownloadLooking, colorDownloadQueued;
    QColorGroup availabilityColours;
    int availabilityThreshold;
    bool colorSourceView;
    QColor colorSourceNotConnected, colorSourceBlacklisted, colorSourceConnecting, colorSourceQueued, colorSourceDownloading;

    QFont listFont, consoleFont;

    bool debugEnabled;

    // DCOP methods
    virtual void submitURL(QString url);
    virtual void consoleCommand(QString command);

protected:
    virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);

    bool queryClose();
    void restoreState(KConfig* conf);
    void saveState(KConfig* conf);

#ifdef HAVE_KTABWIDGET
    KTabWidget* pageTab;
#else
    QTabWidget* pageTab;
#endif

public slots:
    void sendConsoleMessage(const QString& txt);

    void show();
    void hide();

    void enableDebugConsole(bool enable);

    void activatePage(KMLDonkeyPage* page);
    void activatePage(int page);

private slots:
    void closing();

    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsConfigureConnection();
    void optionsConfigureMLDonkey();
    void optionsPreferences();
    void newToolbarConfig();

    void applyPreferences();

    void actionConnectCore();
    void actionConnectCore(const QString& host);
    void actionDisconnectCore();

    void changeStatusbar(const QString& text);
    void changeCaption(const QString& text);

    void connectDonkey();
    void disconnectDonkey();
    void donkeyConnected();
    void donkeyDisconnected(int);
    void checkReconnect();

    void updateStatus(int64 ul, int64 dl, int64 sh, int nsh, int tul, int tdl, int uul, int udl, int ndl, int ncp);

    void hostListUpdated();

private:
    void setupAccel();
    void setupActions();
    QWidget* buildInterface();
    void addPage(KMLDonkeyPage* page, const QIconSet& iconset, const QString& label);
    void removePage(KMLDonkeyPage* page);
    void populateConnectMenu();

private:
    KConfig* conf;

    int reconnect;

    KActionMenu* m_connectAction;
    KToggleAction* m_toolbarAction;
    KToggleAction* m_statusbarAction;
    bool ShowStatusbarLabels;
    bool SaveStatOnExit, persistentReconnect;
    QString coreCharset;

    QPtrList<KMLDonkeyPage> pages;

    ConsolePage* consolePage;
    ServerPage* serverPage;
    DownloadPage* downloadPage;
    SharePage* sharePage;
    FriendPage* friendPage;
    SearchPage *searchPage;
    DebugPage *debugPage;

    QLabel *statInfo, *statServer, *statFiles, *statShare, *statTransfer, *statRate;

    KMLDonkeyPreferences* prefs;

    QTimer* timer;

    QString lastHost;
    QPtrList<KAction> connectActions;
    QSignalMapper* connectMapper;
    QSignalMapper* pageMapper;
};

#endif // __kmldonkey_h__
