/* -*- c++ -*-
 *
 * $Id: mlconfig.h,v 1.4 2003/07/30 13:46:30 dipesh Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: mlconfig.h,v $
 * Revision 1.4  2003/07/30 13:46:30  dipesh
 * added directory-browser
 *
 * Revision 1.3  2003/07/25 15:42:53  dipesh
 * Added the enableNetwork() donkey-function and changed "Configure MLDonkey" to
 * handle enable/disable Networks another way. The way used previous was working
 * as well, but the core didn't send something back to show that that a Network
 * was enabled/disabled. So, to be able to work at the search/network combo always
 * with the actual enabled networks the new function is used now. Stupid
 * core-behaviour anyway.
 *
 * Revision 1.2  2003/07/22 19:16:03  dipesh
 * Just renamed the saveSize() slot to closeDialog() :-)
 *
 * Revision 1.1  2003/07/20 20:47:41  dipesh
 * and the both new files for the "Configure MLDonkey" feature.
 *
 *
 */

#ifndef __kmldonkey_mlconfig_h__
#define __kmldonkey_mlconfig_h__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qscrollview.h>
#include <kdialogbase.h>
#include <qintdict.h>

class QCheckBox;
class KTextEdit;
class KLineEdit;

class MLDonkeyConfigPageItem : public QObject
{
    Q_OBJECT
public:
    MLDonkeyConfigPageItem(QWidget *parent, const QString& name, const QString& value);
    QString getValue();
private:
    QWidget *parent;

    enum enumType {
        etCheckbox = 0,
        etTextedit,
        etDirectory,
        etLineedit
    };

    enumType Type;
    QCheckBox *checkbox;
    KTextEdit *textedit;
    KLineEdit *lineedit;

private slots:
    void slotDirBtnClicked();
};

class MLDonkeyConfigPage : public QScrollView
{
public:
    MLDonkeyConfigPage(QWidget *parent = 0);
    void addOption(const QString& name, const QString& value);
    void addEnableNetwork(const QString& name, const int nwnum, const bool enable);

    QVBox *box;
    QMap<QString, MLDonkeyConfigPageItem*> items;
    QIntDict<QCheckBox> enableNets;
};

class MLDonkeyConfig : public KDialogBase
{
    Q_OBJECT
public:
    MLDonkeyConfig(QWidget* parent = 0);

private:
    QMap<QString, QString> options;

    typedef QMap<QString, QString> treeMap;
    treeMap tree;

    typedef QMap<QString, MLDonkeyConfigPage*> pagesMap;
    pagesMap pages;

protected slots:
    void saveOptions();
    void closeDialog();
};

#endif // __kmldonkey_mlconfig_h__
