/* -*- c++ -*-
 *
 * $Id: page.h,v 1.1 2003/06/19 21:50:45 gibreel Exp $
 *
 * Copyright (C) 2003 Petter E. Stokke <gibreel@gibreel.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Log: page.h,v $
 * Revision 1.1  2003/06/19 21:50:45  gibreel
 * Split the various pages off into individual objects, and made a ton of code
 * cleanups, API changes, and not a few bugfixes in the process. The
 * disconnect/reconnect bug, especially, now seems to be gone.
 *
 */

#ifndef __kmldonkey_page_h__
#define __kmldonkey_page_h__

class KActionCollection;
class QFont;
class KConfig;
class KMLDonkeyPreferences;


/**
 * The interface definition for a KMLDonkey page, containing only virtual
 * functions that any object providing this interface should redefine.
 * They are not pure virtual functions, but instead provide default
 * implementations that do nothing, as it is expected that not all of these
 * methods will be needed by all pages.
 */
class KMLDonkeyPage
{
public:
    /**
     * This method is passed KMLDonkey's KActionCollection, to which the page
     * should add its actions.
     */
    virtual void setupActions(KActionCollection*) {}

    /**
     * This method is called when the prefs dialog is about to be opened.
     * If the page needs to load some values into it, this is where it
     * should do it.
     */
    virtual void configurePrefsDialog(KMLDonkeyPreferences*) {}

    /**
     * This method is called when the global prefs have changed, and the
     * page needs to update its state. If prefs is non-null, the prefs have
     * just changed because the prefs dialog was applied, and if there is
     * any local state that needs to be fetched from it (ie. anything that
     * was loaded into it in configurePrefsDialog() above) this should be
     * done first of all.
     */
    virtual void applyPreferences(KMLDonkeyPreferences* = 0) {}

    /**
     * Called when KMLDonkey wants the page to dump its state. It is passed
     * the KConfig object into which it should do this.
     */
    virtual void saveState(KConfig*) {}

    /**
     * KMLDonkey passed a KConfig object to this function, from which it
     * expects the page to restore its state. It is implied that it should
     * also act upon this state - this is usually done through a simple
     * call to applyPreferences(0) above.
     */
    virtual void restoreState(KConfig*) { applyPreferences(); }

    /**
     * This is called when the core disconnects. The page should unload all
     * its connection specific data in this method.
     */
    virtual void clear() {}
};

#endif
